<?php
/**
*	Theme Options Config File
*	@version	1.0
*
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

if ( !class_exists( "ReduxFramework" ) ) {
	return;
}

function crocal_eutf_redux_dimensions_validation( $field, $value, $existing_value ) {
	$error = false;

	if ( empty( $value['width'] ) || !is_numeric( $value['width'] ) ) {
		$error = true;
	}
	if ( empty( $value['height'] ) || !is_numeric( $value['height'] ) ) {
		$error = true;
	}

	if ( $error == true ) {
		$value = $existing_value;
		$field['msg'] = esc_html__( 'You must provide a numerical value for both options.', 'crocal' );
	}

	$return['value'] = $value;
	if ( $error == true ) {
		$return['error'] = $field;
	}
	return $return;

}

if (!class_exists("Crocal_Eutf_Redux_Framework_config")) {

	class Crocal_Eutf_Redux_Framework_config {

		public $args = array();
		public $sections = array();
		public $theme;
		public $ReduxFramework;

		public function __construct() {
			// Set the default arguments
			$this->setArguments();

			// Create the sections and fields
			$this->setSections();

			// No errors please
			if ( !isset( $this->args['opt_name'] ) ) {
				return;
			}
			$this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
		}

		public function crocal_eutf_redux_customizer_visibility() {
			$visibility = apply_filters( 'crocal_eutf_redux_customizer_visibility', false );
			return $visibility;
		}

		public function setSections() {

			/**
			 * Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
			 * */
			global $crocal_eutf_social_list, $crocal_eutf_button_type_selection, $crocal_eutf_button_shape_selection, $crocal_eutf_button_color_selection, $crocal_eutf_area_height;

			//Gravity Forms
			$crocal_eutf_gravity_options = array();
			if ( class_exists( 'RGFormsModel' ) ) {
				$gravity_forms = RGFormsModel::get_forms( 1, 'title' );
				if ( $gravity_forms ) {
					$crocal_eutf_gravity_options = array( esc_html__( 'Select a form to display.', 'crocal' ) => '' );
					foreach ( $gravity_forms as $gravity_form ) {
						$crocal_eutf_gravity_options[ $gravity_form->id ] = $gravity_form->title;
					}
				}
			}

			$crocal_eutf_social_options = $crocal_eutf_social_list;

			$crocal_eutf_portfolio_social_options = array(
				'email' => esc_html__( 'E-mail', 'crocal' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'pinterest' => 'Pinterest',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'eut-likes' => '(Euthemians) Likes',
			);

			$crocal_eutf_portfolio_term_selection = array(
				'none' => esc_html__( 'None', 'crocal' ),
				'portfolio_category' => esc_html__( 'Portfolio Category', 'crocal' ),
				'portfolio_field' => esc_html__( 'Portfolio Field', 'crocal' ),
			);

			$crocal_eutf_post_social_options = array(
				'email' => esc_html__( 'E-mail', 'crocal' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'eut-likes' => '(Euthemians) Likes',
			);

			$crocal_eutf_product_social_options = array(
				'email' => esc_html__( 'E-mail', 'crocal' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'eut-likes' => '(Euthemians) Likes',
			);

			$crocal_eutf_event_social_options = array(
				'email' => esc_html__( 'E-mail', 'crocal' ),
				'twitter' => 'Twitter',
				'facebook' => 'Facebook',
				'linkedin' => 'LinkedIn',
				'google-plus' => 'Google Plus',
				'reddit' => 'reddit',
				'tumblr' => 'Tumblr',
				'eut-likes' => '(Euthemians) Likes',
			);

			$crocal_eutf_event_mode_selection = array(
				'small' => esc_html__( 'Small Media', 'crocal' ),
				'grid' => esc_html__( 'Grid' , 'crocal' ),
			);

			$crocal_eutf_blog_mode_selection = array(
				'large' => esc_html__( 'Large Media', 'crocal' ),
				'small' => esc_html__( 'Small Media', 'crocal' ),
				'masonry' => esc_html__( 'Masonry' , 'crocal' ),
				'grid' => esc_html__( 'Grid' , 'crocal' ),
			);

			$crocal_eutf_blog_image_mode_selection = array(
				'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'crocal' ),
				'landscape-medium' => esc_html__( 'Landscape Medium Crop', 'crocal' ),
				'large' => esc_html__( 'Resize ( Large )', 'crocal' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
			);

			$crocal_eutf_blog_grid_image_mode_selection = array(
				'square' => esc_html__( 'Square Small Crop', 'crocal' ),
				'landscape' => esc_html__( 'Landscape Small Crop', 'crocal' ),
				'portrait' => esc_html__( 'Portrait Small Crop', 'crocal' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
			);

			$crocal_eutf_blog_masonry_image_mode_selection = array(
				'large' => esc_html__( 'Resize ( Large )', 'crocal' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
			);

			$crocal_eutf_search_grid_image_mode_selection = array(
				'square' => esc_html__( 'Square Small Crop', 'crocal' ),
				'landscape' => esc_html__( 'Landscape Small Crop', 'crocal' ),
				'portrait' => esc_html__( 'Portrait Small Crop', 'crocal' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
			);

			$crocal_eutf_search_masonry_image_mode_selection = array(
				'large' => esc_html__( 'Resize ( Large )', 'crocal' ),
				'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
				'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
			);

			$crocal_eutf_blog_columns_selection = array(
				'2' => '2',
				'3' => '3',
				'4' => '4',
				'5' => '5',
			);
			$crocal_eutf_blog_columns_selection_tablet = array(
				'2' => '2',
				'3' => '3',
				'4' => '4',
			);
			$crocal_eutf_blog_columns_selection_mobile = array(
				'1' => '1',
				'2' => '2',
			);
			$crocal_eutf_blog_headings_tag_selection = array(
				'auto' => esc_html__( 'Auto', 'crocal' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'div'  => 'div',
			);

			$crocal_eutf_blog_headings_selection = array(
				'auto' => esc_html__( 'Auto', 'crocal' ),
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'crocal' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'crocal' ),
				'small-text' => esc_html__( 'Small Text', 'crocal' ),
				'link-text' => esc_html__( 'Link Text', 'crocal' ),
			);

			$crocal_eutf_event_headings_selection = array(
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
			);

			$crocal_eutf_theme_layout_selection = array(
				'stretched' => esc_html__( 'Stretched', 'crocal' ),
				'boxed' => esc_html__( 'Boxed', 'crocal' ),
				'framed' => esc_html__( 'Framed', 'crocal' ),
			);

			$crocal_eutf_layout_selection = array(
				'none' => array('alt' => esc_html__( 'Full Width', 'crocal' ), 'img' => ReduxFramework::$_url . 'assets/img/1col.png'),
				'left' => array('alt' => esc_html__( 'Left Sidebar', 'crocal' ), 'img' => ReduxFramework::$_url . 'assets/img/2cl.png'),
				'right' => array('alt' => esc_html__( 'Right Sidebar', 'crocal' ), 'img' => ReduxFramework::$_url . 'assets/img/2cr.png'),
			);

			$crocal_eutf_align_selection = array(
				'left' => esc_html__( 'Left', 'crocal' ),
				'right' => esc_html__( 'Right', 'crocal' ),
			);

			$crocal_eutf_align_selection_extra = array(
				'left' => esc_html__( 'Left', 'crocal' ),
				'center' => esc_html__( 'Center', 'crocal' ),
				'right' => esc_html__( 'Right', 'crocal' ),
			);

			$crocal_eutf_align_selection_full = array(
				'left-top' => esc_html__( 'Left Top', 'crocal' ),
				'left-center' => esc_html__( 'Left Center', 'crocal' ),
				'left-bottom' => esc_html__( 'Left Bottom', 'crocal' ),
				'center-top' => esc_html__( 'Center Top', 'crocal' ),
				'center-center' => esc_html__( 'Center Center', 'crocal' ),
				'center-bottom' => esc_html__( 'Center Bottom', 'crocal' ),
				'right-top' => esc_html__( 'Right Top', 'crocal' ),
				'right-center' => esc_html__( 'Right Center', 'crocal' ),
				'right-bottom' => esc_html__( 'Right Bottom', 'crocal' ),
			);

			$crocal_eutf_animation_selection = array(
				'fade-in' => esc_html__( 'Default', 'crocal' ),
				'none' => esc_html__( 'None', 'crocal' ),
				'fade-in-up' => esc_html__( 'Fade In Up', 'crocal' ),
				'fade-in-down' => esc_html__( 'Fade In Down', 'crocal' ),
				'fade-in-left' => esc_html__( 'Fade In Left', 'crocal' ),
				'fade-in-right' => esc_html__( 'Fade In Right', 'crocal' ),
				'zoom-in' => esc_html__( 'Zoom In', 'crocal' ),
				'zoom-out' => esc_html__( 'Zoom Out', 'crocal' ),
			);

			$crocal_eutf_title_bg_mode = array(
				'color' => esc_html__( 'Color Only', 'crocal' ),
				'featured' => esc_html__( 'Featured Image', 'crocal' ),
				'custom' => esc_html__( 'Custom Image', 'crocal' ),
			);

			$crocal_eutf_title_bg_mode_limited = array(
				'color' => esc_html__( 'Color Only', 'crocal' ),
				'custom' => esc_html__( 'Custom Image', 'crocal' ),

			);

			$crocal_eutf_background_type = array(
				'transparent' => esc_html__( 'None', 'crocal' ),
				'colored' => esc_html__( 'Background', 'crocal' ),
				'advanced' => esc_html__( 'Stretched Background', 'crocal' ),
			);

			$crocal_eutf_header_menu_options = array(
				'search' => esc_html__( 'Search', 'crocal' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7 or Gravity Forms Required Required)', 'crocal' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'crocal' ),
				'cart' => esc_html__( 'Shopping Cart (WooCommerce Required)', 'crocal' ),
				'social' => esc_html__( 'Social Icons', 'crocal' ),
			);
			$crocal_eutf_header_menu_options_default = array(
				'search' => false,
				'form' => false,
				'language' => false,
				'cart' => false,
				'social' => false,
			);

			$crocal_eutf_header_menu_selection = array(
				'default' => esc_html__( 'Default', 'crocal' ),
				'disabled' => esc_html__( 'Disabled', 'crocal' ),
			);

			$crocal_eutf_top_bar_options = array(
				'menu' => esc_html__( 'Menu (Assigned: Menus - Manage Locations)', 'crocal' ),
				'text' => esc_html__( 'Text', 'crocal' ),
				'search' => esc_html__( 'Search', 'crocal' ),
				'language' => esc_html__( 'Language selector (WPML or Polylang Required)', 'crocal' ),
				'form' => esc_html__( 'Contact Form (Contact Form 7 or Gravity Forms Required)', 'crocal' ),
				'social' => esc_html__( 'Social Icons', 'crocal' ),
			);
			$crocal_eutf_top_bar_options_default = array(
				'menu' => false,
				'text' => false,
				'search' => false,
				'language' => false,
				'form' => false,
				'social' => false,
			);

			$crocal_eutf_menu_animations = array(
				'none' => esc_html__( 'None', 'crocal' ),
				'fade-in' => esc_html__( 'Fade in', 'crocal' ),
				'fade-in-up' => esc_html__( 'Fade in Up', 'crocal' ),
				'fade-in-down' => esc_html__( 'Fade in Down', 'crocal' ),
				'fade-in-left' => esc_html__( 'Fade in Left', 'crocal' ),
				'fade-in-right' => esc_html__( 'Fade in Right', 'crocal' ),
			);
			$crocal_eutf_menu_pointers = array(
				'none' => esc_html__( 'None', 'crocal' ),
				'arrow' => esc_html__( 'Arrow', 'crocal' ),
				'arrow-not-first-level' => esc_html__( 'Arrow (exclude first level items)', 'crocal' ),
			);

			$crocal_eutf_color_selection = array(
				'dark' => esc_html__( 'Dark', 'crocal' ),
				'light' => esc_html__( 'Light', 'crocal' ),
				'primary-1' => esc_html__( 'Primary 1', 'crocal' ),
				'primary-2' => esc_html__( 'Primary 2', 'crocal' ),
				'primary-3' => esc_html__( 'Primary 3', 'crocal' ),
				'primary-4' => esc_html__( 'Primary 4', 'crocal' ),
				'primary-5' => esc_html__( 'Primary 5', 'crocal' ),
				'primary-6' => esc_html__( 'Primary 6', 'crocal' ),
			);
			$crocal_eutf_color_selection_extra = array(
				'dark' => esc_html__( 'Dark', 'crocal' ),
				'light' => esc_html__( 'Light', 'crocal' ),
				'primary-1' => esc_html__( 'Primary 1', 'crocal' ),
				'primary-2' => esc_html__( 'Primary 2', 'crocal' ),
				'primary-3' => esc_html__( 'Primary 3', 'crocal' ),
				'primary-4' => esc_html__( 'Primary 4', 'crocal' ),
				'primary-5' => esc_html__( 'Primary 5', 'crocal' ),
				'primary-6' => esc_html__( 'Primary 6', 'crocal' ),
				'custom' => esc_html__( 'Custom', 'crocal' ),
			);

			$crocal_eutf_bg_color_selection = array(
				'none' => esc_html__( 'None', 'crocal' ),
				'dark' => esc_html__( 'Dark', 'crocal' ),
				'light' => esc_html__( 'Light', 'crocal' ),
				'primary-1' => esc_html__( 'Primary 1', 'crocal' ),
				'primary-2' => esc_html__( 'Primary 2', 'crocal' ),
				'primary-3' => esc_html__( 'Primary 3', 'crocal' ),
				'primary-4' => esc_html__( 'Primary 4', 'crocal' ),
				'primary-5' => esc_html__( 'Primary 5', 'crocal' ),
				'primary-6' => esc_html__( 'Primary 6', 'crocal' ),
			);

			$crocal_eutf_bg_color_selection_extra = array(
				'transparent' => esc_html__( 'Transparent', 'crocal' ),
				'dark' => esc_html__( 'Dark', 'crocal' ),
				'light' => esc_html__( 'Light', 'crocal' ),
				'primary-1' => esc_html__( 'Primary 1', 'crocal' ),
				'primary-2' => esc_html__( 'Primary 2', 'crocal' ),
				'primary-3' => esc_html__( 'Primary 3', 'crocal' ),
				'primary-4' => esc_html__( 'Primary 4', 'crocal' ),
				'primary-5' => esc_html__( 'Primary 5', 'crocal' ),
				'primary-6' => esc_html__( 'Primary 6', 'crocal' ),
				'custom' => esc_html__( 'Custom', 'crocal' ),
			);
			$crocal_eutf_content_bg_color_selection_extra = array(
				'none' => esc_html__( 'None', 'crocal' ),
				'dark' => esc_html__( 'Dark', 'crocal' ),
				'light' => esc_html__( 'Light', 'crocal' ),
				'primary-1' => esc_html__( 'Primary 1', 'crocal' ),
				'primary-2' => esc_html__( 'Primary 2', 'crocal' ),
				'primary-3' => esc_html__( 'Primary 3', 'crocal' ),
				'primary-4' => esc_html__( 'Primary 4', 'crocal' ),
				'primary-5' => esc_html__( 'Primary 5', 'crocal' ),
				'primary-6' => esc_html__( 'Primary 6', 'crocal' ),
				'custom' => esc_html__( 'Custom', 'crocal' ),
			);

			$crocal_eutf_header_mode_selection = array(
				'default' => array('alt' => esc_html__( 'Default', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-default.png' ),
				'logo-top' => array('alt' => esc_html__( 'Logo on Top', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-logo-top.png' ),
				'side' => array('alt' => esc_html__( 'Side', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/header/header-mode-side.png' ),
			);
			$crocal_eutf_header_menu_mode_selection = array(
				'default' => array('alt' => esc_html__( 'Default', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/menu/default-menu.png' ),
				'split' => array('alt' => esc_html__( 'Split', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/menu/split-menu.png' ),
				'logo-center' => array('alt' => esc_html__( 'Logo Center', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/menu/logo-center.png' ),
			);

			$crocal_eutf_header_style = array(
				'default' => esc_html__( 'Default', 'crocal' ),
				'dark' => esc_html__( 'Dark', 'crocal' ),
				'light' => esc_html__( 'Light', 'crocal' ),
			);

			$crocal_eutf_title_style = array(
				'advanced' => esc_html__( 'Advanced Title', 'crocal' ),
				'simple' => esc_html__( 'Simple Title', 'crocal' ),
			);

			$crocal_eutf_enable_selection = array(
				'no' => esc_html__( 'No', 'crocal' ),
				'yes' => esc_html__( 'Yes', 'crocal' ),
			);

			$crocal_eutf_menu_responsibe_style_selection = array(
				'1' => esc_html__( 'Style 1', 'crocal' ),
				'2' => esc_html__( 'Style 2', 'crocal' ),
			);

			$crocal_eutf_menu_responsibe_toggle_selection = array(
				'icon' => esc_html__( 'Icon', 'crocal' ),
				'text' => esc_html__( 'Text', 'crocal' ),
			);

			$crocal_eutf_footer_column_selection = array(
				'footer-1' => array('alt' => esc_html__( 'Footer 1', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-1.png' ),
				'footer-2' => array('alt' => esc_html__( 'Footer 2', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-2.png' ),
				'footer-3' => array('alt' => esc_html__( 'Footer 3', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-3.png' ),
				'footer-4' => array('alt' => esc_html__( 'Footer 4', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-4.png' ),
				'footer-5' => array('alt' => esc_html__( 'Footer 5', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-5.png' ),
				'footer-6' => array('alt' => esc_html__( 'Footer 6', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-6.png' ),
				'footer-7' => array('alt' => esc_html__( 'Footer 7', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-7.png' ),
				'footer-8' => array('alt' => esc_html__( 'Footer 8', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-8.png' ),
				'footer-9' => array('alt' => esc_html__( 'Footer 9', 'crocal' ), 'img' => get_template_directory_uri() . '/includes/images/footer/footer-9.png' ),
			);


			$crocal_eutf_opacity_selection_simple = array(
				'0'  => '0%',
				'10' => '10%',
				'20' => '20%',
				'30' => '30%',
				'40' => '40%',
				'50' => '50%',
				'60' => '60%',
				'70' => '70%',
				'80' => '80%',
				'90' => '90%',
				'100'=> '100%',
			);

			$crocal_eutf_opacity_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.10' => '10%',
				'0.15' => '15%',
				'0.20' => '20%',
				'0.25' => '25%',
				'0.30' => '30%',
				'0.35' => '35%',
				'0.40' => '40%',
				'0.45' => '45%',
				'0.50' => '50%',
				'0.55' => '55%',
				'0.60' => '60%',
				'0.65' => '65%',
				'0.70' => '70%',
				'0.75' => '75%',
				'0.80' => '80%',
				'0.85' => '85%',
				'0.90' => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);
			$crocal_eutf_ratio_selection = array(
				'0'    => '0%',
				'0.05' => '5%',
				'0.1'  => '10%',
				'0.15' => '15%',
				'0.2'  => '20%',
				'0.25' => '25%',
				'0.3'  => '30%',
				'0.35' => '35%',
				'0.4'  => '40%',
				'0.45' => '45%',
				'0.5'  => '50%',
				'0.55' => '55%',
				'0.6'  => '60%',
				'0.65' => '65%',
				'0.7'  => '70%',
				'0.75' => '75%',
				'0.8'  => '80%',
				'0.85'  => '85%',
				'0.9'  => '90%',
				'0.95' => '95%',
				'1'    => '100%',
			);

			$crocal_eutf_headings_tag_selection = array(
				'div' => 'div',
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
			);

			$crocal_eutf_headings_selection = array(
				'h2'  => 'h2',
				'h3'  => 'h3',
				'h4'  => 'h4',
				'h5'  => 'h5',
				'h6'  => 'h6',
				'leader-text' => esc_html__( 'Leader Text', 'crocal' ),
				'subtitle-text' => esc_html__( 'Subtitle Text', 'crocal' ),
				'small-text' => esc_html__( 'Small Text', 'crocal' ),
				'link-text' => esc_html__( 'Link Text', 'crocal' ),
			);

			$crocal_eutf_pattern_selection = array(
				'none' => esc_html__( 'No', 'crocal' ),
				'default' => esc_html__( 'Yes', 'crocal' ),
			);

			$crocal_eutf_padding_selection = array(
				'none' => esc_html__( 'None', 'crocal' ),
				'1x' => esc_html__( '1x', 'crocal' ),
				'2x' => esc_html__( '2x', 'crocal' ),
				'3x' => esc_html__( '3x', 'crocal' ),
				'4x' => esc_html__( '4x', 'crocal' ),
				'5x' => esc_html__( '5x', 'crocal' ),
				'6x' => esc_html__( '6x', 'crocal' ),
			);
			$crocal_eutf_padding_selection_extra = array(
				'none' => esc_html__( 'None', 'crocal' ),
				'1x' => esc_html__( '1x', 'crocal' ),
				'2x' => esc_html__( '2x', 'crocal' ),
				'3x' => esc_html__( '3x', 'crocal' ),
				'4x' => esc_html__( '4x', 'crocal' ),
				'5x' => esc_html__( '5x', 'crocal' ),
				'6x' => esc_html__( '6x', 'crocal' ),
				'custom' => esc_html__( 'Custom', 'crocal' ),
			);

			$crocal_eutf_content_size_selection = array(
				'large' => esc_html__( 'Large', 'crocal' ),
				'medium' => esc_html__( 'Medium', 'crocal' ),
				'small' => esc_html__( 'Small', 'crocal' ),
			);

			$crocal_eutf_container_size_selection = array(
				'default' => esc_html__( 'Default', 'crocal' ),
				'large' => esc_html__( 'Large', 'crocal' ),
			);

			//Standard Fonts
			$crocal_eutf_std_fonts = array(
				"Arial, Helvetica, sans-serif"                         => "Arial, Helvetica, sans-serif",
				"'Arial Black', Gadget, sans-serif"                    => "'Arial Black', Gadget, sans-serif",
				"'Bookman Old Style', serif"                           => "'Bookman Old Style', serif",
				"'Comic Sans MS', cursive"                             => "'Comic Sans MS', cursive",
				"Courier, monospace"                                   => "Courier, monospace",
				"Garamond, serif"                                      => "Garamond, serif",
				"Georgia, serif"                                       => "Georgia, serif",
				"Impact, Charcoal, sans-serif"                         => "Impact, Charcoal, sans-serif",
				"'Lucida Console', Monaco, monospace"                  => "'Lucida Console', Monaco, monospace",
				"'Lucida Sans Unicode', 'Lucida Grande', sans-serif"   => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
				"'MS Sans Serif', Geneva, sans-serif"                  => "'MS Sans Serif', Geneva, sans-serif",
				"'MS Serif', 'New York', sans-serif"                   => "'MS Serif', 'New York', sans-serif",
				"'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
				"Tahoma,Geneva, sans-serif"                            => "Tahoma, Geneva, sans-serif",
				"'Times New Roman', Times,serif"                       => "'Times New Roman', Times, serif",
				"'Trebuchet MS', Helvetica, sans-serif"                => "'Trebuchet MS', Helvetica, sans-serif",
				"Verdana, Geneva, sans-serif"                          => "Verdana, Geneva, sans-serif",
			);
			$crocal_eutf_std_fonts = apply_filters( 'crocal_eutf_std_fonts', $crocal_eutf_std_fonts );

			$crocal_eutf_feature_section_post_types_selection = array(
				'page'   => esc_html__( 'Pages', 'crocal' ),
				'portfolio'   => esc_html__( 'Portfolio Items', 'crocal' ),
				'post'   => esc_html__( 'Posts', 'crocal' ),
				'product'   => esc_html__( 'Products', 'crocal' ),
				'tribe_events'   => esc_html__( 'Events', 'crocal' ),
			);

			$crocal_eutf_container_size_selector = array(
				'container' => esc_html__( 'Container Size' , 'crocal' ),
				'large' => esc_html__( 'Large' , 'crocal' ),
				'medium' => esc_html__( 'Medium' , 'crocal' ),
				'small' => esc_html__( 'Small' , 'crocal' ),
			);

			$regenerate_link = '<a href="//wordpress.org/plugins/regenerate-thumbnails/" target="_blank">' . esc_html__( 'regenerate your thumbnails', 'crocal' ) . '</a>';
			$crocal_gmap_api_key_link = '<a href="//developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">' . esc_html__( 'Generate Google Map API Key', 'crocal' ) . '</a>';
			$crocal_gmap_style_link = '<a href="//mapstyle.withgoogle.com/" target="_blank">' . esc_html__( 'Styling Wizard Google Maps API.', 'crocal' ) . '</a>';

			$crocal_is_google = apply_filters( 'crocal_eutf_gfonts_visibility', true );
			// ACTUAL DECLARATION OF SECTIONS

			$this->sections[] = array(
				'icon' => 'el-icon-cogs',
				'title' => esc_html__( 'General Settings', 'crocal' ),
				'id' => 'eut_redux_section_general_settings',
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'theme_layout',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Theme Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select between Streched or Boxed for the theme basic Layout.', 'crocal' ),
						'options' => $crocal_eutf_theme_layout_selection,
						'default' => 'stretched',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'boxed_size',
						'type' => 'text',
						'default' => '1440',
						'title' => esc_html__( 'Theme Wrapper Size', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Theme Wrapper width in px (Default is 1440).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'theme_layout', 'equals', 'boxed' ),
					),
					array(
						'id' => 'frame_size',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Frame Size', 'crocal' ),
						'subtitle' => esc_html__( 'Enter frame size in px (Default is 30).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'theme_layout', 'equals', 'framed' ),
					),
					array(
						'id'          => 'frame_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Frame Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Select a color for the framed layout.', 'crocal' ),
						'default'     => '#ffffff',
						'required' => array( 'theme_layout', 'equals', 'framed' ),
						'transparent' => false,
					),
					array(
						'id' => 'container_size',
						'type' => 'text',
						'default' => '1170',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Container width in px (Default is 1170).', 'crocal' ),
						'validate' => 'numeric',
					),

					array(
						'id' => 'sidebar_size',
						'type' => 'select',
						'title' => esc_html__( 'Sidebar Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Sidebar width in % (Default is 30%).', 'crocal' ),
						'options' => array(
							'10' => esc_html__( '10%', 'crocal' ),
							'20' => esc_html__( '20%', 'crocal' ),
							'30' => esc_html__( '30%', 'crocal' ),
							'40' => esc_html__( '40%', 'crocal' ),
							'50' => esc_html__( '50%', 'crocal' ),
						),
						'default' => '30',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'content_sidebar_space',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Content Sidebar Space', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Space between Content and Sibar in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
					),

					array(
						'id'       => 'body_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Theme Background Image / Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image or color for the theme.', 'crocal' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#171A1D',
						),
					),
					array(
						'id'       => 'content_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Content Background Image / Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image or color for the content.', 'crocal' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#ffffff',
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Logos', 'crocal' ),
				'id' => 'eut_redux_section_logos',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-photo',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'logo',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Default Header', 'crocal' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-default.png', 'width' => '222', 'height' => '36' ),
						'subtitle' => esc_html__( 'Upload the logo for the Default Header.', 'crocal' ),
					),
					array(
						'id' => 'logo_light',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Light Header', 'crocal' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-light.png', 'width' => '222', 'height' => '36' ),
						'subtitle' => esc_html__( 'Upload the logo for the Light Header.', 'crocal' ),
					),
					array(
						'id' => 'logo_dark',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Dark Header', 'crocal' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-default.png', 'width' => '222', 'height' => '36' ),
						'subtitle' => esc_html__( 'Upload the logo for the Dark Header.', 'crocal' ),
					),
					array(
						'id' => 'logo_side',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Side Header', 'crocal' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-side.png', 'width' => '222', 'height' => '36' ),
						'subtitle' => esc_html__( 'Upload the logo for the Side Header.', 'crocal' ),
					),
					array(
						'id' => 'logo_sticky',
						'url'=> true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Sticky Header', 'crocal' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-sticky.png', 'width' => '222', 'height' => '36' ),
						'subtitle' => esc_html__( 'Upload the logo for the Sticky Header.', 'crocal' ),
					),
					array(
						'id' => 'logo_responsive',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Logo Responsive Header', 'crocal' ),
						'read-only' => false,
						'default' => array( 'url' => get_template_directory_uri() .'/images/logos/logo-responsive.png', 'width' => '222', 'height' => '36' ),
						'subtitle' => esc_html__( 'Upload the logo for the Responsive Header.', 'crocal' ),
					),
					array(
						'id'=>'logo_as_text_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Logo as text', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle logo as text on or off. When on, all logo images will be replaced with site name.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
					array(
						'id'=>'logo_custom_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Logo Custom Link URL', 'crocal' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your logo. If empty homepage will be used instead.', 'crocal' ),
						"default" => '',
					),
					array(
						'id' => 'replace_admin_logo',
						'type' => 'switch',
						'title' => esc_html__( 'Replace Admin Logo', 'crocal' ),
						'subtitle'=> esc_html__( 'Replace the backend admin logo with your company logo.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'       => 'admin_logo',
						'type'     => 'media',
						'title' => esc_html__( 'Admin Logo', 'crocal' ),
						'subtitle' => esc_html__( 'Select the image for your company logo. ( If empty Logo Default will be used instead )', 'crocal' ),
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
					array(
						'id' => 'admin_logo_height',
						'type' => 'text',
						'default' => '84',
						'title' => esc_html__( 'Admin Logo Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the company logo height in px (Default is 84).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'replace_admin_logo', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Theme Loader / Transitions', 'crocal' ),
				'desc' => esc_html__( 'Enable or Disable Theme Loader, Theme Loader Spinner and page transitions.', 'crocal' ),
				'id' => 'eut_redux_section_theme_loader',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-photo',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'theme_loader',
						'type' => 'switch',
						'title' => esc_html__( 'Theme Loader', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader.', 'crocal' ),
						'default' => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'show_spinner',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Spinner', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable Theme Loader Spinner.', 'crocal' ),
						'default' => '1',
						'1' => esc_html__( 'On', 'crocal' ),
						'0' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'theme_loader', 'equals', '1' ),
					),
					array(
						'id' => 'page_transition',
						'type' => 'select',
						'title' => esc_html__( 'Page Transition', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the page transition when navigating from one page to another. It is worth noting that it maybe causes problems with plugins which use ajax requests.', 'crocal' ),
						'options' => array(
							'none' => esc_html__( 'None', 'crocal' ),
							'fade-in' => esc_html__( 'Fade In', 'crocal' ),
							'left-to-right' => esc_html__( 'Left to Right', 'crocal' ),
							'right-to-left' => esc_html__( 'Right to Left', 'crocal' ),
							'top-to-bottom' => esc_html__( 'Top to Bottom', 'crocal' ),
							'bottom-to-top' => esc_html__( 'Bottom to Top', 'crocal' ),
							'zoom-out' => esc_html__( 'Zoom Out', 'crocal' ),
						),
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'theme_loader', 'equals', '1' ),
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Style Options', 'crocal' ),
				'id' => 'eut_redux_section_style_options',
				'desc' => sprintf( wp_kses( __( 'To customize the color scheme, please use the <a href="%s">Live Color Customizer</a>.', 'crocal' ), array( 'br' => array(), 'a' => array( 'href' => true, 'target' => true ) ) ), esc_url( admin_url('/customize.php') ) ),
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Top Bar Options', 'crocal' ),
				'id' => 'eut_redux_section_top_bar_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the TopBar area, just above the Header, in order to add various elements in two different positions, left and right.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-arrow-up',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'top_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Top Bar Area', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the TopBar Area, the area just above your header.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'             => 'top_bar_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Top Bar Spacing', 'crocal' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the TopBar Area.', 'crocal' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'crocal'),
						'default'        => array(
							'padding-top'     => '15px',
							'padding-bottom'  => '15px',
							'units'           => 'px',
						),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Top Bar Full Width', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Top Bar Area.', 'crocal' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'crocal' ),
							'fullwidth-element' => esc_html__( 'Yes', 'crocal' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_top_bar_left',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Left Top Bar Area', 'crocal' ),
						'desc' => esc_html__( 'In side navigation mode, Left Top Bar Area is shown first.', 'crocal' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_left_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Left Area', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Left TopBar Area.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_left_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Left Area Elements', 'crocal' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Left TopBar Area.', 'crocal' ),
						'options' => $crocal_eutf_top_bar_options,
						'default' => $crocal_eutf_top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false, 'media_buttons' => false, 'textarea_rows' => 5 ),
						'title' => esc_html__( 'Left Area Text', 'crocal' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Left TopBar Area.', 'crocal' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_left_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Left Form Type', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'crocal' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'crocal' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'crocal' ),
						),
						'default' => 'contact-form',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_left_form',
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'crocal' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'crocal' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'top_bar_left_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Left Area Form', 'crocal' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'crocal' ),
						'options' => $crocal_eutf_gravity_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id'=>'top_bar_left_lang_style',
						'type' => 'select',
						'title' => esc_html__( 'Left Language Selector Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the style of your language selector.', 'crocal' ),
						'options' => array(
							'dropdown' => esc_html__( 'Dropdown', 'crocal' ),
							'horizontal-list' => esc_html__( 'Horizontal List', 'crocal' ),
						),
						'default' => 'dropdown',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_left_lang_content',
						'type' => 'select',
						'title' => esc_html__( 'Left Language Selector Content', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the content of your language selector.', 'crocal' ),
						'options' => array(
							'flag-name' => esc_html__( 'Flag and Language name', 'crocal' ),
							'flag' => esc_html__( 'Flag', 'crocal' ),
							'name' => esc_html__( 'Language name', 'crocal' ),
						),
						'default' => 'flag-name',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_left_lang_hide_current_lang',
						'type' => 'select',
						'title' => esc_html__( 'Hide Current Language', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to hide the current language.', 'crocal' ),
						'options' => array(
							'no' => esc_html__( 'No', 'crocal' ),
							'yes' => esc_html__( 'Yes', 'crocal' ),
						),
						'default' => 'no',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
							array( 'top_bar_left_lang_style', 'equals', 'horizontal-list' ),
						),
					),
					array(
						'id' => 'top_bar_left_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Left Area Social Icons', 'crocal' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'crocal' ),
						'desc' => '',
						'class' => 'eut-redux-columns',
						'label' => true,
						'options' => $crocal_eutf_social_options,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_left_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'   => 'info_top_bar_right',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Right Top Bar Area', 'crocal' ),
						'desc' => esc_html__( 'In side navigation mode, Right Top Bar Area is shown second.', 'crocal' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'top_bar_right_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Right Area', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Right TopBar Area.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'top_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'top_bar_right_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Right Area Elements', 'crocal' ),
						'subtitle' => esc_html__( 'Enable or Disable the elements you like to show in the Right TopBar Area.', 'crocal' ),
						'options' => $crocal_eutf_top_bar_options,
						'default' => $crocal_eutf_top_bar_options_default,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false, 'media_buttons' => false, 'textarea_rows' => 5 ),
						'title' => esc_html__( 'Right Area Text', 'crocal' ),
						'subtitle' => esc_html__( 'Place the text you wish for your Right TopBar Area.', 'crocal' ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_right_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Right Form Type', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'crocal' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'crocal' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'crocal' ),
						),
						'default' => 'contact-form',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id' => 'top_bar_right_form',
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'crocal' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'crocal' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'top_bar_right_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Right Area Form', 'crocal' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'crocal' ),
						'options' => $crocal_eutf_gravity_options,
						'default' => '',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id'=>'top_bar_right_lang_style',
						'type' => 'select',
						'title' => esc_html__( 'Right Language Selector Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the style of your language selector.', 'crocal' ),
						'options' => array(
							'dropdown' => esc_html__( 'Dropdown', 'crocal' ),
							'horizontal-list' => esc_html__( 'Horizontal List', 'crocal' ),
						),
						'default' => 'dropdown',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_right_lang_content',
						'type' => 'select',
						'title' => esc_html__( 'Right Language Selector Content', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the content of your language selector.', 'crocal' ),
						'options' => array(
							'flag-name' => esc_html__( 'Flag and Language name', 'crocal' ),
							'flag' => esc_html__( 'Flag', 'crocal' ),
							'name' => esc_html__( 'Language name', 'crocal' ),
						),
						'default' => 'flag-name',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
					array(
						'id'=>'top_bar_right_lang_hide_current_lang',
						'type' => 'select',
						'title' => esc_html__( 'Hide Current Language', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to hide the current language.', 'crocal' ),
						'options' => array(
							'no' => esc_html__( 'No', 'crocal' ),
							'yes' => esc_html__( 'Yes', 'crocal' ),
						),
						'default' => 'no',
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
							array( 'top_bar_right_lang_style', 'equals', 'horizontal-list' ),
						),
					),
					array(
						'id' => 'top_bar_right_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Right Area Social Icons', 'crocal' ),
						'subtitle' => esc_html__( 'Select your social icons. Social URLs are configured from Theme Options - Social Media', 'crocal' ),
						'label' => true,
						'class' => 'eut-redux-columns',
						'options' => $crocal_eutf_social_options,
						'required' => array(
							array( 'top_bar_enabled', 'equals', '1' ),
							array( 'top_bar_right_enabled', 'equals', '1' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header Options', 'crocal' ),
				'id' => 'eut_redux_section_header_options',
				'header' => '',
				'desc' => esc_html__( 'Here you can set your preferences for the Theme Header(Logo, Menu and Menu Elements). Notice that most of the options below depend on your first selection where you have to select among Default, Logo on Top or Side Navigation Header.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'header_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Header Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your Header Mode. keep in mind that this is one of the most important options for the appearance of your site. Your selection here will determine the following section options.', 'crocal' ),
						'options' => $crocal_eutf_header_mode_selection,
						'default' => 'default',
					),
					array(
						'id'=>'header_menu_mode',
						'type' => 'image_select',
						'title' => esc_html__( 'Main Menu Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your main menu mode. Select between default and split menu', 'crocal' ),
						'options' => $crocal_eutf_header_menu_mode_selection,
						'default' => 'default',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id'=>'split_menu_item_position',
						'type' => 'button_set',
						'title' => esc_html__( 'Extra Menu Item Position ', 'crocal' ),
						'subtitle'=> esc_html__( 'Select where you want to place the extra menu item in case of even menu items.', 'crocal' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'crocal' ),
							'right' => esc_html__( 'Right', 'crocal' ),
						),
						'default' => 'left',
						'required' => array(
							array( 'header_mode', 'equals', 'default' ),
							array( 'header_menu_mode', 'equals', 'split' ),
						),
					),
					array(
						'id' => 'header_height',
						'type' => 'text',
						'default' => '90',
						'title' => esc_html__( 'Header Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Header height in px (Default is 90).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'header_side_width',
						'type' => 'text',
						'default' => '300',
						'title' => esc_html__( 'Header Width', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Header Width in px (Default is 300).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'             => 'header_side_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'top'           => 'false',
						'bottom'          => 'false',
						'title'          => esc_html__( 'Spacing', 'crocal' ),
						'subtitle'       => esc_html__( 'Set the spacings for the content of the Header.', 'crocal' ),
						'desc'           => esc_html__( 'Set spacing Right, Left in px.', 'crocal'),
						'default'        => array(
							'padding-left'     => '30px',
							'padding-right'  => '30px',
							'units'           => 'px',
						),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'       => 'header_side_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Header Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode_limited,
						'default'  => 'color',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'       => 'header_side_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the header.', 'crocal' ),
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_side_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
							array( 'header_side_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'header_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Full Width', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable/Disable full width Header.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id'   => 'info_logo_default_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Default Header', 'crocal' ),
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'logo_height',
						'type' => 'text',
						'default' => '18',
						'title' => esc_html__( 'Logo Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 18).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id'   => 'info_logo_ontop_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Logo on Top Header', 'crocal' ),
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_height',
						'type' => 'text',
						'default' => '18',
						'title' => esc_html__( 'Logo Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 18).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_height',
						'type' => 'text',
						'default' => '180',
						'title' => esc_html__( 'Logo Area Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Logo Area Height in px (Default is 120).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Logo Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Align your Logo as you wish.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id'   => 'info_logo_side_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Side Header', 'crocal' ),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_logo_height',
						'type' => 'text',
						'default' => '90',
						'title' => esc_html__( 'Logo Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Logo Height in px (Default is 90).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_logo_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Logo Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Align your Logo as you wish.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'             => 'header_side_logo_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => array('em', 'px', '%'),
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Spacing', 'crocal' ),
						'subtitle'       => esc_html__( 'Set the spacings of the Logo.', 'crocal' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'crocal'),
						'default'        => array(
							'padding-top'     => '100px',
							'padding-bottom'  => '100px',
							'units'           => 'px',
						),
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id'   => 'info_menu_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Menu Options', 'crocal' ),
					),
					array(
						'id' => 'menu_type',
						'type' => 'select',
						'title' => esc_html__( 'Menu Type', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the type of the Main Menu.', 'crocal' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'crocal' ),
							'button' => esc_html__( 'Button Style', 'crocal' ),
							'underline' => esc_html__( 'Underline', 'crocal' ),
							'hidden' => esc_html__( 'Hidden', 'crocal' ),
							'advanced-hidden' => esc_html__( 'Advanced Hidden', 'crocal' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'default' ),
					),
					array(
						'id' => 'menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'right',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'default' ),
							array( 'header_menu_mode', 'equals', 'default' ),
							array( 'menu_type', '!=', 'hidden' ),
						),
					),
					array(
						'id' => 'logo_center_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'crocal' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'crocal' ),
							'right' => esc_html__( 'Right', 'crocal' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'default' ),
							array( 'header_menu_mode', 'equals', 'logo-center' ),
							array( 'menu_type', '!=', 'hidden' ),
						),
					),
					array(
						'id' => 'header_bottom_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Menu Area Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Menu Area Height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_logo_menu_type',
						'type' => 'select',
						'title' => esc_html__( 'Menu Type', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the type of the Main Menu.', 'crocal' ),
						'options' => array(
							'classic' => esc_html__( 'Classic', 'crocal' ),
							'button' => esc_html__( 'Button Style', 'crocal' ),
							'underline' => esc_html__( 'Underline', 'crocal' ),
							'hidden' => esc_html__( 'Hidden', 'crocal' ),
						),
						'default' => 'classic',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'logo-top' ),
					),
					array(
						'id' => 'header_top_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'logo-top' ),
							array( 'header_top_logo_menu_type', '!=', 'hidden' ),
						),
					),
					array(
						'id' => 'submenu_pointer',
						'type' => 'select',
						'title' => esc_html__( 'Sub Menu Pointer', 'crocal' ),
						'subtitle'=> esc_html__( 'Choose pointer for the submenu.', 'crocal' ),
						'desc' => esc_html__( "Note: This setting will not affect hidden menu.", 'crocal' ),
						'options' => $crocal_eutf_menu_pointers,
						'default' => 'none',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id' => 'submenu_top_position',
						'type' => 'text',
						'default' => '0',
						'title' => esc_html__( 'Sub Menu Position', 'crocal' ),
						'subtitle' => esc_html__( 'Define the distance between the top position of the Submenu and the bottom of the Header in px. (Default is 0 - Submenu starts at the bottom of the Header).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'header_mode', '!=', 'side' ),
					),
					array(
						'id' => 'header_menu_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Type', 'crocal' ),
						'subtitle' => esc_html__( 'Select your menu type.', 'crocal' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'crocal' ),
							'slide' => esc_html__( 'Slide', 'crocal' ),
						),
						'default' => 'toggle',
						'validate' => 'not_empty',
						'required' => array( 'header_mode', 'equals', 'side' ),
					),
					array(
						'id' => 'header_side_menu_align',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Align your Menu as you wish.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'header_mode', 'equals', 'side' ),
						),

					),
					array(
						'id'   => 'info_menu_elements',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Menu Elements Options', 'crocal' ),
					),
					array(
						'id'=>'header_menu_options_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Menu Elements', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or disable the use of various elements in your header like socials, search, language selector and Contact Form.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'header_menu_options',
						'type' => 'sortable',
						'mode' => 'checkbox',
						'title' => esc_html__( 'Menu Elements Options', 'crocal' ),
						'subtitle' => esc_html__( 'Enable / Disable various menu elements options.', 'crocal' ),
						'options' => $crocal_eutf_header_menu_options,
						'default' => $crocal_eutf_header_menu_options_default,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'header_menu_type_form',
						'type' => 'button_set',
						'title' => esc_html__( 'Menu Form Type', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the type of your form.', 'crocal' ),
						'options' => array(
							'contact-form' => esc_html__( 'Contact Form 7', 'crocal' ),
							'gravity-form' => esc_html__( 'Gravity Form', 'crocal' ),
						),
						'default' => 'contact-form',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_form',
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'crocal' ),
						'subtitle' => esc_html__( 'Select the form for your Contact Form.', 'crocal' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'wpcf7_contact_form', 'numberposts' => -1 ),
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'contact-form' ),
						),
					),
					array(
						'id' => 'header_menu_gravity_form',
						'type' => 'select',
						'title' => esc_html__( 'Menu Form', 'crocal' ),
						'subtitle' => esc_html__( 'Select the form for your Gravity Form.', 'crocal' ),
						'options' => $crocal_eutf_gravity_options,
						'default' => '',
						'required' => array(
							array( 'header_menu_options_enabled', 'equals', '1' ),
							array( 'header_menu_type_form', 'equals', 'gravity-form' ),
						),
					),
					array(
						'id'=>'header_menu_social_mode',
						'type' => 'select',
						'title' => esc_html__( 'Menu Social Icons Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social icons single or modal.', 'crocal' ),
						'options' => array(
							'modal' => esc_html__( 'Modal Popup', 'crocal' ),
							'single' => esc_html__( 'Single Social Icons', 'crocal' ),
						),
						"default" => 'modal',
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_menu_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Menu Social Icons', 'crocal' ),
						'subtitle' => esc_html__( 'Select the social icons.', 'crocal' ),
						'desc' => '',
						'class' => 'eut-redux-columns',
						'label' => true,
						'options' => $crocal_eutf_social_options,
						'required' => array( 'header_menu_options_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_header_text',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Header Text Options', 'crocal' ),
					),
					array(
						'id' => 'header_menu_text_element',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Header Text Element', 'crocal' ),
						'subtitle' => esc_html__( 'Type your text here. In case you are using the default header, make sure the height of your element does not exceed the header height.', 'crocal' ),
						'default' => '',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Sticky Header Options', 'crocal' ),
				'id' => 'eut_redux_section_sticky_header_options',
				'header' => '',
				'desc' => esc_html__( 'You can enable the Sticky Header option if you want to provide constant access to the Header elements while visitors scroll down the page. These settings will not affect if you select the Side Header Mode in Theme Options > Header Options.', 'crocal' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'header_sticky_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Header', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header option.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array(
							array( 'header_mode', '!=', 'side' ),
						),
					),
					array(
						'id' => 'header_sticky_type',
						'type' => 'select',
						'title' => esc_html__( 'Sticky Header Type', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the type of the Sticky Header.', 'crocal' ),
						'options' => array(
							'simple' => esc_html__( 'Simple', 'crocal' ),
							'shrink' => esc_html__( 'Shrink', 'crocal' ),
							'scrollup' => esc_html__( 'Scroll Up', 'crocal' ),
						),
						'default' => 'simple',
						'validate' => 'not_empty',
						'required' => array( 'header_sticky_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'header_sticky_shrink_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Header Shrink Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Header in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'header_sticky_enabled', 'equals', '1' ),
							array( 'header_sticky_type', '!=', 'simple' ),
						),
					),
					array(
						'id' => 'header_sticky_shrink_logo_height',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Logo Shrink Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the shrink height for the Logo in px (Default is 30).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'header_sticky_enabled', 'equals', '1' ),
							array( 'header_sticky_type', '!=', 'simple' ),
						),
					),
					array(
						'id'=>'header_sticky_devices_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Devices Sticky Header', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable the Sticky Header on small devices ( Tablet Portrait and Mobiles ).', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Header Options / Hidden Menu Options', 'crocal' ),
				'id' => 'eut_redux_section_responsive_header_options',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the responsive header.', 'crocal' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-screen',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'responsive_header_threshold',
						'type' => 'text',
						'default' => '1024',
						'title' => esc_html__( 'Responsive Header Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the screensize you want to activate the responsive header in px, based on the menu items you have (Default is 1024).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'responsive_header_height',
						'type' => 'text',
						'default' => '70',
						'title' => esc_html__( 'Responsive Header Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Header height in px (Default is 70).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'responsive_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Responsive Header overlaps the content.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_responsive_logo_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo Options for the Responsive Header', 'crocal' ),
					),
					array(
						'id' => 'responsive_logo_height',
						'type' => 'text',
						'default' => '12',
						'title' => esc_html__( 'Responsive Logo Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Logo height in px (Default is 12).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id'   => 'info_responsive_menu_options',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Responsive / Hidden Menu Options', 'crocal' ),
					),
					array(
						'id' => 'menu_responsive_toggle_selection',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Toggle Button Selection', 'crocal' ),
						'subtitle' => esc_html__( 'Select the toggle button content for your responsive menu.', 'crocal' ),
						'options' => $crocal_eutf_menu_responsibe_toggle_selection,
						'default' => 'icon',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_toggle_text',
						'type' => 'text',
						'title' => esc_html__( 'Responsive Menu Text', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the text for your responsive menu.', 'crocal' ),
						'default' => 'Menu',
						'required' => array( 'menu_responsive_toggle_selection', 'equals', 'text' ),
					),
					array(
						'id' => 'menu_responsive_open_type',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive / Hidden Menu Type', 'crocal' ),
						'subtitle' => esc_html__( 'Select your responsive menu type.', 'crocal' ),
						'options' => array(
							'toggle' => esc_html__( 'Toggle', 'crocal' ),
							'slide' => esc_html__( 'Slide', 'crocal' ),
						),
						'default' => 'slide',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_align',
						'type' => 'select',
						'title' => esc_html__( 'Responsive Menu Align', 'crocal' ),
						'subtitle' => esc_html__( 'Select your responsive menu align.', 'crocal' ),
						'options' => array(
							'left' => esc_html__( 'Left', 'crocal' ),
							'center' => esc_html__( 'Center', 'crocal' ),
						),
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_width',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Responsive / Hidden Menu Width', 'crocal' ),
						'subtitle' => esc_html__( 'Select the width for your hidden menu.', 'crocal' ),
						'options' => array(
							'small' => esc_html__( 'Small', 'crocal' ),
							'medium' => esc_html__( 'Medium', 'crocal' ),
							'large' => esc_html__( 'Large', 'crocal' ),
						),
						'default' => 'small',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'menu_responsive_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Responsive / Hidden Menu Text', 'crocal' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'crocal' ),
						'default' => '',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-arrow-down',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Bottom / Footer Areas', 'crocal' ),
				'id' => 'eut_redux_section_footer_options',
				'desc' => esc_html__( 'These areas appear at the bottom of your pages. Define your preferences.', 'crocal' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'sticky_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Sticky Areas', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to make sticky these areas.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'bottom_bar_area',
						'type' => 'select',
						'title' => esc_html__( 'Bottom Bar Area Item', 'crocal' ),
						'subtitle' => esc_html__( 'Select an area item for your Bottom Bar Area.', 'crocal' ),
						'data' => 'posts',
						'args' => array( 'post_type' => 'area-item', 'numberposts' => -1 ),
						'default' => '',
					),
					array(
						'id'   => 'info_footer_widgets',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Footer Widgets Settings', 'crocal' ),
					),
					array(
						'id'       => 'footer_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Footer Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'footer_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the footer.', 'crocal' ),
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'footer_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'footer_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id'=>'footer_widgets_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Widgets Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable the Footer Area to show the widget areas of the footer.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'footer_widgets_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Footer Column Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Footer column layout.', 'crocal' ),
						'options' => $crocal_eutf_footer_column_selection,
						'default' => 'footer-1',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Full Width', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Area.', 'crocal' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'crocal' ),
							'fullwidth-element' => esc_html__( 'Yes', 'crocal' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Footer Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space above the footer area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space below the footer area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
						'required' => array( 'footer_widgets_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_footer_bar',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Footer Bar Settings', 'crocal' ),
					),
					array(
						'id'=>'footer_bar_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Bar Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable the Footer Bar Area to add text (copyright), bottom menu and socials.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'footer_bar_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Full Width', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Footer Bar Area.', 'crocal' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'crocal' ),
							'fullwidth-element' => esc_html__( 'Yes', 'crocal' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_bar_align_center',
						'type' => 'select',
						'title' => esc_html__( 'Footer Bar Center', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if the Footer Bar elements will be centered.', 'crocal' ),
						'options' => array(
							'no' => esc_html__( 'No', 'crocal' ),
							'yes' => esc_html__( 'Yes', 'crocal' ),
						),
						'default' => 'yes',
						'validate' => 'not_empty',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id'=>'footer_copyright_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Footer Copyright Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable the Footer Copyright Area. Edit it as you wish.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_copyright_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Copyright Text', 'crocal' ),
						'subtitle' => esc_html__( 'Type your copyright text or anything else you want.', 'crocal' ),
						'default' => '<p>With <i class="eut-text-primary-1 fas fa-heart"></i> by <a href="//themeforest.net/user/euthemians/portfolio" target="_blank">Euthemians</a> - Premium Themes</p>',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'footer_copyright_visibility', 'equals', '1' ),
						),
					),
					array(
						'id'=>'second_area_visibility',
						'type' => 'button_set',
						'title' => esc_html__( 'Second Footer Area', 'crocal' ),
						'subtitle'=> esc_html__( 'This is the second position in the Footer Bar Area. You can easily add the Bottom Menu (assigned in Appearance > Menus) or socials.', 'crocal' ),
						'options' => array(
							'1' => esc_html__( 'Hide', 'crocal' ),
							'2' => esc_html__( 'Menu', 'crocal' ),
							'3' => esc_html__( 'Socials', 'crocal' ),
							'4' => esc_html__( 'Text', 'crocal' ),
						),
						'default' => '1',
						'required' => array( 'footer_bar_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'footer_second_copyright_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Text', 'crocal' ),
						'subtitle' => esc_html__( 'Type your text or anything else you want.', 'crocal' ),
						'default' => '',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '4' ),
						),
					),
					array(
						'id' => 'footer_social_display',
						'type' => 'select',
						'title' => esc_html__( 'Footer Social Display', 'crocal' ),
						'subtitle'=> esc_html__( 'Select how you want to display your social items.', 'crocal' ),
						'options' => array(
							'text' => esc_html__( 'Text', 'crocal' ),
							'icon' => esc_html__( 'Icons', 'crocal' ),
						),
						'default' => 'text',
						'validate' => 'not_empty',
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
					array(
						'id' => 'footer_social_options',
						'type' => 'checkbox',
						'title' => esc_html__( 'Footer Social items', 'crocal' ),
						'subtitle' => esc_html__( 'Select your social icons.', 'crocal' ),
						'desc' => '',
						'class' => 'eut-redux-columns',
						'label' => true,
						'options' => $crocal_eutf_social_options,
						'required' => array(
							array( 'footer_bar_visibility', 'equals', '1' ),
							array( 'second_area_visibility', 'equals', '3' ),
						),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Blog Options', 'crocal' ),
				'id' => 'eut_redux_section_blog_options',
				'desc' => esc_html__( 'Changes here will affect the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays and not when you use the shortcodes to create a blog page. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'crocal' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'blog_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Blog Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the layout for the assigned blog page. Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'blog_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar for the assigned blog page.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'blog_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Blog Sliding Area for the assigned blog page.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'blog_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Blog Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id'   => 'info_style_blog_settings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Blog Style and Basic Blog Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the default blog.', 'crocal' ),
					),
					array(
						'id' => 'blog_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Mode', 'crocal' ),
						'subtitle' => esc_html__( 'Select the blog mode', 'crocal' ),
						'options' => $crocal_eutf_blog_mode_selection,
						'default' => 'large',
					),
					array(
						'id' => 'blog_shadow_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Style', 'crocal' ),
						'subtitle' => esc_html__( 'Select the blog style', 'crocal' ),
						'options' =>array(
							'shadow-mode' => esc_html__( 'With Shadow', 'crocal' ),
							'no-shadow-mode' => esc_html__( 'Without Shadow', 'crocal' ),
						),
						'default' => 'shadow-mode',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_media_area',
						'type' => 'switch',
						'title' => esc_html__( 'Blog Media Area visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Select if you want to enable media area', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'blog_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select your Blog Image Size', 'crocal' ),
						'options' => $crocal_eutf_blog_image_mode_selection,
						'default' => 'landscape-large-wide',
						'required' => array(
							array( 'blog_mode','equals', 'large' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_grid_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Grid Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select your Blog Image Size', 'crocal' ),
						'options' => $crocal_eutf_blog_grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Blog Masonry_Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select your Blog Masonry Image Size', 'crocal' ),
						'options' => $crocal_eutf_blog_masonry_image_mode_selection,
						'default' => 'medium',
						'required' => array(
							array( 'blog_mode','equals', 'masonry' ),
							array( 'blog_media_area', 'equals', '1' ),
						),
					),
					array(
						'id' => 'blog_image_prio',
						'type' => 'select',
						'title' => esc_html__( 'Blog Featured Image Priority', 'crocal' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed instead of media element', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
						'required' => array( 'blog_media_area', 'equals', '1' ),
					),
					array(
						'id' => 'blog_columns_large_screen',
						'type' => 'select',
						'title' => esc_html__( 'Blog Columns Large Screens', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Blog Columns for large screens', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection,
						'default' => '3',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns',
						'type' => 'select',
						'title' => esc_html__( 'Blog Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Blog Columns', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection,
						'default' => '3',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Blog Tablet Landscape Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Blog Tablet Portrait Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Blog Mobile Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection_mobile,
						'default' => '1',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id' => 'blog_gutter',
						"type" => "select",
						"title" => esc_html__( "Gutter between items", "crocal" ),
						'subtitle' => esc_html__( 'Add gutter among items.', 'crocal' ),
						"options" => array(
							'yes' => esc_html__( "Yes", "crocal" ),
							'no' => esc_html__( "No", "crocal" ),
						),
						'default' => 'yes',
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
						),
					),
					array(
						'id'=>'blog_gutter_size',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Gutter Size', 'crocal' ),
						'subtitle' => esc_html__( 'Define the gutter size.', 'crocal' ),
						'required' => array(
							array( 'blog_mode','!=', 'large' ),
							array( 'blog_mode','!=', 'small' ),
							array( 'blog_gutter','equals', 'yes' ),
						),
					),
					array(
						"id" => "blog_display_style",
						"type" => "select",
						"title" => esc_html__( "Display Style", "crocal"),
						"subtitle" => esc_html__("Define your pagination style.", "crocal" ),
						"options" => array(
							'pagination' => esc_html__( "Pagination", "crocal" ),
							"load-more" => esc_html__( "Load More", "crocal" ),
							"infinite-scroll" => esc_html__( "Infinite Scroll", "crocal" ),
						),
						'default' => 'pagination',
						'required' => array( 'blog_mode', '!=', 'large' ),
					),
					array(
						'id'=>'blog_load_more_title',
						'type' => 'text',
						'default' => 'Load More',
						'title' => esc_html__( 'Load More Title', 'crocal' ),
						'subtitle' => esc_html__( 'Title for load more.', 'crocal' ),
						'required' => array( 'blog_display_style', 'equals', 'load-more' ),
					),
					array(
						"id" => "blog_animation",
						"type" => "select",
						"title" => esc_html__( "Blog CSS Animation", "crocal"),
						"subtitle" => esc_html__("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "crocal" ),
						"options" => array(
							'none' => esc_html__( "No", "crocal" ),
							"eut-fade-in" => esc_html__( "Fade In", "crocal" ),
							"eut-fade-in-up" => esc_html__( "Fade In Up", "crocal" ),
							"eut-fade-in-down" => esc_html__( "Fade In Down", "crocal" ),
							"eut-fade-in-left" => esc_html__( "Fade In Left", "crocal" ),
							"eut-fade-in-right" => esc_html__( "Fade In Right", "crocal" ),
							"eut-zoom-in" => esc_html__( "Zoom In", "crocal" ),
						),
						'default' => 'none',
					),
					array(
						'id' => 'blog_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Blog Title Tag', 'crocal' ),
						'subtitle' => esc_html__( 'Select tag for your blog title.', 'crocal' ),
						'options' => $crocal_eutf_blog_headings_tag_selection,
						'default' => 'auto',
					),
					array(
						'id' => 'blog_heading',
						'type' => 'select',
						'title' => esc_html__( 'Blog Title Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select size and typography for your blog title.', 'crocal' ),
						'options' => $crocal_eutf_blog_headings_selection,
						'default' => 'h1',
					),
					array(
						'id'=>'blog_excerpt_length_small',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'crocal' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'blog_mode', '!=', 'large' ),
					),
					array(
						'id' => 'blog_auto_excerpt',
						'type' => 'switch',
						'title' => esc_html__( 'Auto Excerpt', 'crocal' ),
						'subtitle'=> esc_html__( "Adds automatic excerpt to all posts. If auto excerpt is off, blog will show all content, a desired 'cut-off' can be inserted in each post with more quicktag.", 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'blog_mode', 'equals', 'large' ),
					),

					array(
						'id'=>'blog_excerpt_length',
						'type' => 'text',
						'default' => '55',
						'title' => esc_html__( 'Excerpt Length', 'crocal' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 55).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array(
							array( 'blog_auto_excerpt', 'equals', '1' ),
							array( 'blog_mode', 'equals', 'large' ),
						),
					),
					array(
						'id' => 'blog_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'crocal' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'blog_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Field Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments field of your blog overview.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'blog_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Field Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the author field of your blog overview.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'blog_date_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Date Field Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the date field of your blog overview.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'blog_like_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Like Field Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the like field of your blog overview.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'blog_categories_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Categories Field Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the categories field of your blog overview.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'   => 'info_style_blog_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Blog Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default blog header.', 'crocal' ),
					),
					array(
						'id' => 'blog_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your blog header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'dark',
					),
					array(
						'id' => 'blog_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Blog Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Blog Header overlaps the content. Combine this option with the Light or Dark Header.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'=>'blog_title',
						'type' => 'select',
						'title' => esc_html__( 'Main Blog Title', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to use the site name and tagline as the main blog title or hide it.', 'crocal' ),
						'options' => array(
							'sitetitle' => esc_html__( 'Site Title / Tagline', 'crocal' ),
							'none' => esc_html__( 'None', 'crocal' ),
						),
						'default' => 'sitetitle',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter blog title height (Default is Large Height).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter blog title minimum height in px (Default is 200).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'blog_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the default blog title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'blog_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the default blog title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'blog_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Background for the blog page, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'blog_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the default blog title.', 'crocal' ),
						'required' => array( 'blog_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'blog_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'blog_title_bg_mode', '!=', 'color' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Post Settings', 'crocal' ),
				'id' => 'eut_redux_section_single_post_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Posts. Notice that most of them can be overridden when you create a single post.', 'crocal' ),
				'submenu' => true,
				'icon' => 'el-icon-edit',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Post Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Post Custom Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'post_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Post Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Post Custom Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'post_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Post Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Posts. Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'post_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Posts.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'post_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Post Content Width', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Single Post Content width (only for Full Width Post Layout)', 'crocal' ),
						'options' => $crocal_eutf_container_size_selector,
						'default' => 'small',
					),
					array(
						'id' => 'post_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Post Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Post Sliding Area if you want.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'post_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Post Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'post_feature_image_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Featured Image Visibility (Standard Post)', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle Featured Image on or off.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'post_category_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Categories Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post categories.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'post_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your single posts.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'post_comments_position',
						'type' => 'select',
						'title' => esc_html__( 'Comments Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select where to display comments area ', 'crocal' ),
						'options' => array(
							'default' => esc_html__( 'Below Content', 'crocal' ),
							'section' => esc_html__( 'Separate Section ', 'crocal' ),
						),
						'default' => 'section',
						'validate' => 'not_empty',
						'required' => array( 'post_comments_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_post_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Post Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'crocal' ),
					),
					array(
						'id' => 'post_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your post header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'dark',
					),
					array(
						'id' => 'post_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Post Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Post Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single post.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'   => 'info_style_post_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Post Title Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default single post title.', 'crocal' ),
					),
					array(
						'id' => 'post_title_style',
						'type' => 'select',
						'default' => 'advanced',
						'title' => esc_html__( 'Title Style', 'crocal' ),
						'subtitle' => esc_html__( 'Select Post Title Style', 'crocal' ),
						'options' => $crocal_eutf_title_style,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter post title height(Default is Large Height).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter post title minimum height in px (Default is 200).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the default post title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'post_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the default post title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'post_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Post Title Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode,
						'default'  => 'color',
						'required' => array( 'post_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'post_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the default post title.', 'crocal' ),
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'post_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'post_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'post_title_style', 'equals', 'advanced' ),
							array( 'post_title_bg_mode', '!=', 'color' ),
						),
					),

					array(
						'id'   => 'info_style_post_meta',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Post Meta Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set socials, tags and author info for your post.', 'crocal' ),
					),
					array(
						'id' => 'post_author_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Author Info Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Author Info field.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'post_author_intro_text',
						'type' => 'text',
						'title' => esc_html__( 'Author Intro Text', 'crocal' ),
						'subtitle' => esc_html__( 'Type the intro text, above author name.', 'crocal' ),
						"default" => 'About the author',
						'required' => array( 'post_author_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_tag_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Post Tags Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the post tags.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'post_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'crocal' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Posts.', 'crocal' ),
						'options' => $crocal_eutf_post_social_options,
						'default' => 0,
					),

					array(
						'id'   => 'info_style_post_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per post.', 'crocal' ),
					),
					array(
						'id' => 'post_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'post_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in posts.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'post_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'   => 'info_style_post_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'crocal' ),
					),
					array(
						'id'=>'post_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Post / Archives / Categories / Tags.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'post_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'post_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'post_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_post_related',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Related Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the related posts.', 'crocal' ),
					),
					array(
						'id'=>'post_related_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Related Posts Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the related posts.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'post_related_title_first',
						'type' => 'text',
						'title' => esc_html__( 'Related Posts First Title', 'crocal' ),
						'subtitle' => esc_html__( 'Type the text for the first posts related title.', 'crocal' ),
						"default" => 'You might also like',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_related_title_second',
						'type' => 'text',
						'title' => esc_html__( 'Related Posts Second Title', 'crocal' ),
						'subtitle' => esc_html__( 'Type the text for the second posts related title.', 'crocal' ),
						"default" => '',
						'required' => array( 'post_related_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_post_nav',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Navigation Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'crocal' ),
					),
					array(
						'id'=>'post_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Posts Navigation Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the posts navigation.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'post_nav_layout',
						'type' => 'select',
						'title' => esc_html__( 'Post Navigation Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the post navigation layout', 'crocal' ),
						'options' =>array(
							'layout-1' => esc_html__( 'Classic', 'crocal' ),
							'layout-2' => esc_html__( 'With Background Image', 'crocal' ),
						),
						'default' => 'layout-1',
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Post Navigation Same Term', 'crocal' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'crocal' ),
						'default' => 0,
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'post_backlink_id',
						'type' => 'select',
						'title' => esc_html__( 'Post Backlink', 'crocal' ),
						'subtitle' => esc_html__( 'Select the overview page for your post backlink.', 'crocal' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'post_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'post_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'crocal' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'crocal' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'crocal'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array( 'post_nav_layout', 'equals', 'layout-1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-pencil',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Options', 'crocal'),
				'id' => 'eut_redux_section_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'crocal' ),
				'desc' => esc_html__( 'You can find the basic settings for the pages here. Almost everything can be overridden when you edit a single page.', 'crocal' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Page Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Page Custom Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'page_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Page Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Page Custom Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'page_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Page Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the layout for the pages. Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'page_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the pages in case you do not use full width layout.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'page_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Page Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the pages.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'page_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Page Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id'=>'page_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Easily disable the comments for all pages.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'page_comments_position',
						'type' => 'select',
						'title' => esc_html__( 'Comments Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select where to display comments area ', 'crocal' ),
						'options' => array(
							'default' => esc_html__( 'Below Content', 'crocal' ),
							'section' => esc_html__( 'Separate Section ', 'crocal' ),
						),
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'page_comments_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_page_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Page Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default page header.', 'crocal' ),
					),
					array(
						'id' => 'page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'light',
					),
					array(
						'id' => 'page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single page.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'   => 'info_style_page_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Page Title Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default page title.', 'crocal' ),
					),
					array(
						'id' => 'page_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Page title height (Default is Large Height).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter page title minimum height in px (Default is 200).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the default page title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the default page title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the default page title.', 'crocal' ),
						'required' => array( 'page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_page_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per page.', 'crocal' ),
					),
					array(
						'id' => 'page_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'page_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'page_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'   => 'info_style_page_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'crocal' ),
					),
					array(
						'id'=>'page_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Page.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'page_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'page_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'page_breadcrumbs_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-briefcase',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Portfolio Options', 'crocal' ),
				'id' => 'eut_redux_section_portfolio_options',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'portfolio_slug',
						'type' => 'text',
						'default' => 'portfolio',
						'title' => esc_html__( 'Slug', 'crocal' ),
						'subtitle' => esc_html__( "Enter Portfolio Slug (Default is 'portfolio'). If you change it, go to Settings - Permalinks and click on Save Changes.", 'crocal' ),
						'desc' => esc_html__( "Slug must not be used anywhere else (e.g: category, page, post).", 'crocal' ),
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Custom Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'portfolio_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Custom Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'portfolio_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Portfolio Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default layout for the Portfolio (single portfolio items). Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'portfolio_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single portfolio items.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'portfolio_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the single portfolio items.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'portfolio_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'portfolio_details_text',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Text', 'crocal' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details title.', 'crocal' ),
						"default" => 'Project Details',
					),
					array(
						'id' => 'portfolio_details_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Details Text Heading Tag', 'crocal' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Portfolio Details Text.', 'crocal' ),
						'options' => $crocal_eutf_headings_tag_selection,
						'default' => 'div',
					),
					array(
						'id' => 'portfolio_details_link_text',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Details Link Text', 'crocal' ),
						'subtitle' => esc_html__( 'Type the text for the Portfolio Details link text.', 'crocal' ),
						"default" => 'View Project',
					),
					array(
						'id'=>'portfolio_comments_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Comments Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the comments of your portfolio.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'portfolio_comments_position',
						'type' => 'select',
						'title' => esc_html__( 'Comments Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select where to display comments area ', 'crocal' ),
						'options' => array(
							'default' => esc_html__( 'Below Content', 'crocal' ),
							'section' => esc_html__( 'Separate Section ', 'crocal' ),
						),
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_comments_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_portfolio_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Portfolio Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default portfolio header.', 'crocal' ),
					),
					array(
						'id' => 'portfolio_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your portfolio header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'light',
					),
					array(
						'id' => 'portfolio_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Portfolio Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single portfolio.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'   => 'info_style_portfolio_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Portfolio Title Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the single default portfolio title.', 'crocal' ),
					),
					array(
						'id' => 'portfolio_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter portfolio title height (Default is Large Height).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter portfolio title minimum height in px (Default is 200).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the default portfolio title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the default portfolio title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'portfolio_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Portfolio Title Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode,
						'default'  => 'color',
					),
					array(
						'id'       => 'portfolio_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the default portfolio title.', 'crocal' ),
						'required' => array( 'portfolio_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'portfolio_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'portfolio_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_portfolio_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per portfolio item.', 'crocal' ),
					),
					array(
						'id' => 'portfolio_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'portfolio_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your anchor menu.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'portfolio_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show your anchor menu full width.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'   => 'info_style_portfolio_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'crocal' ),
					),
					array(
						'id'=>'portfolio_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Portfolio.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_breadcrumbs_fullwidth',
						'type' => 'checkbox',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'crocal' ),
						'default' => 0,
						'required' => array( 'portfolio_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_portfolio_socials',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Socials Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Socials.', 'crocal' ),
					),
					array(
						'id' => 'portfolio_social_bar_layout',
						'type' => 'select',
						'title' => esc_html__( 'Socials Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Layout for Socials', 'crocal' ),
						'options' => array(
							'layout-1' => esc_html__( 'Bottom Layout', 'crocal' ),
							'layout-2' => esc_html__( 'Side Layout', 'crocal' ),
						),
						'default' => 'layout-1',
					),
					array(
						'id' => 'portfolio_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'crocal' ),
						'subtitle' => esc_html__( 'Enable or Disable the social shares you like in the single portfolio items.', 'crocal' ),
						'options' => $crocal_eutf_portfolio_social_options,
						'default' => 0,
					),
					array(
						'id'   => 'info_style_portfolio_recent',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Recent Items Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Recent Items.', 'crocal' ),
					),
					array(
						'id'=>'portfolio_recents_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Recent Items Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the recent items carousel.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'portfolio_recent_title',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Recent Items Title', 'crocal' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio recent items title.', 'crocal' ),
						"default" => 'More Projects',
						'required' => array( 'portfolio_recents_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_portfolio_nav',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Navigation Bar', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation Bar.', 'crocal' ),
					),
					array(
						'id'=>'portfolio_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Portfolio Navigation Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the portfolio navigation.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'portfolio_nav_layout',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Navigation Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the portfolio navigation layout', 'crocal' ),
						'options' =>array(
							'layout-1' => esc_html__( 'Classic', 'crocal' ),
							'layout-2' => esc_html__( 'With Background Image', 'crocal' ),
							'layout-3' => esc_html__( 'Next Background Image Only', 'crocal' ),
						),
						'default' => 'layout-1',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_nav_next_title',
						'type' => 'text',
						'title' => esc_html__( 'Portfolio Next Title', 'crocal' ),
						'subtitle' => esc_html__( 'Type the text for the portfolio next title.', 'crocal' ),
						"default" => 'Next Project',
						'required' => array( 'portfolio_nav_layout', 'equals', 'layout-3' ),
					),
					array(
						'id' => 'portfolio_nav_term',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Navigation Same Term', 'crocal' ),
						'subtitle' => esc_html__( 'If selected, only navigation items with the same selected taxonomy term will be displayed.', 'crocal' ),
						'options' => $crocal_eutf_portfolio_term_selection,
						'default' => 'none',
						'required' => array( 'portfolio_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'portfolio_backlink_id',
						'type' => 'select',
						'title' => esc_html__( 'Portfolio Backlink', 'crocal' ),
						'subtitle' => esc_html__( 'Select the overview page for your portfolio backlink.', 'crocal' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'portfolio_nav_layout', '!=', 'layout-3' ),
					),
					array(
						'id'             => 'portfolio_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'crocal' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'crocal' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'crocal'),
						'default'        => array(
							'padding-top'     => '30px',
							'padding-bottom'  => '30px',
							'units'           => 'px',
						),
						'required' => array( 'portfolio_nav_layout', 'equals', 'layout-1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'WooCommerce Options', 'crocal'),
				'id' => 'eut_redux_section_woocommerce_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the WooCommerce here.', 'crocal' ),
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'product_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Taxonomy Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default layout for the Product Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'product_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Product Taxonomy.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'product_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Product Taxonomy.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id'   => 'info_style_product_tax_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default Product Taxonomy header.', 'crocal' ),
					),
					array(
						'id' => 'product_tax_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your Product Taxonomy header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'product_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Taxonomy Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_tax_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Product Taxonomy Title Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Product Taxonomy title.', 'crocal' ),
					),
					array(
						'id' => 'product_tax_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title height (Default is 60%).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Product Taxonomy title minimum height in px (Default is 320).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_tax_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the default Product Taxonomy title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_tax_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Product Taxonomy title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'product_tax_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Product Taxonomy Title Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'product_tax_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the default Product Taxonomy title.', 'crocal' ),
						'required' => array( 'product_tax_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'product_tax_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'product_tax_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_product_overview',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Shop Overview Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the shop overview.', 'crocal' ),
					),
					array(
						'id' => 'product_overview_hover_style',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Hover Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the hover style for the product overview.', 'crocal' ),
						'options' => array(
							'hover-style-1' => esc_html__( 'Content Below Image', 'crocal' ),
							'hover-style-2' => esc_html__( 'Top Down Animated Content', 'crocal' ),
						),
						'default' => 'hover-style-1',
					),
					array(
						'id' => 'product_overview_image_effect',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Image effect', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the effect for the overview product image', 'crocal' ),
						'options' => array(
							'none' => esc_html__( 'None', 'crocal' ),
							'second' => esc_html__( 'Second Image on Hover', 'crocal' ),
						),
						'default' => 'second',
					),
					array(
						'id' => 'product_overview_image_zoom_effect',
						'type' => 'select',
						'options' => array(
							'in' => esc_html__( 'Zoom In', 'crocal' ),
							'out' => esc_html__( 'Zoom Out', 'crocal' ),
							'none' => esc_html__( 'None', 'crocal' ),
						),
						'title' => esc_html__( 'Loop Image Zoom Effect', 'crocal' ),
						'subtitle' => esc_html__( 'Choose the image zoom effect.', 'crocal' ),
						'default' => 'none',
					),
					array(
						'id' => 'product_overview_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'crocal' ),
							'square' => esc_html__( 'Square Small Crop', 'crocal' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'crocal' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'crocal' ),
							'large' => esc_html__( 'Resize ( Large )', 'crocal' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
						),
						'title' => esc_html__( 'Loop Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Choose the overview image size.', 'crocal' ),
						'default' => 'default',
					),
					array(
						'id' => 'product_loop_columns',
						'type' => 'select',
						'options' => array(
							'2' => '2',
							'3' => '3',
							'4' => '4',
							'5' => '5',
						),
						'default' => '4',
						'title' => esc_html__( 'Loop Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select the number of columns (Default is 4).', 'crocal' ),
					),
					array(
						'id' => 'product_loop_shop_per_page',
						'type' => 'text',
						'default' => '12',
						'title' => esc_html__( 'Loop Products per Page', 'crocal' ),
						'subtitle' => esc_html__( 'Select how many products per page you want to show (Default is 12).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_overview_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Title Tag', 'crocal' ),
						'subtitle' => esc_html__( 'Select tag for your loop product title.', 'crocal' ),
						'options' => $crocal_eutf_headings_tag_selection,
						'default' => 'h3',
					),
					array(
						'id' => 'product_overview_heading',
						'type' => 'select',
						'title' => esc_html__( 'Loop Product Title Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select size and typography for your loop product title.', 'crocal' ),
						'options' => $crocal_eutf_headings_selection,
						'default' => 'h6',
					),
					array(
						'id' => 'product_overview_image_shadow',
						'type' => 'select',
						'options' => array(
							'none' => esc_html__( "No", "crocal" ),
							"small-shadow" => esc_html__( "Small Shadow", "crocal" ),
							"medium-shadow" => esc_html__( "Medium Shadow", "crocal" ),
							"large-shadow" => esc_html__( "Large Shadow", "crocal" ),
						),
						'title' => esc_html__( 'Add Shadow', 'crocal' ),
						'default' => 'none',
					),
					array(
						'id' => 'product_overview_image_radius',
						'type' => 'select',
						'options' => array(
							'none' => esc_html__( "No", "crocal" ),
							'radius-5' => esc_html__( "Radius 5px", "crocal" ),
							'radius-10' => esc_html__( "Radius 10px", "crocal" ),
							'radius-15' => esc_html__( "Radius 15px", "crocal" ),
							'radius-20' => esc_html__( "Radius 20px", "crocal" ),
							'radius-25' => esc_html__( "Radius 25px", "crocal" ),
							'radius-30' => esc_html__( "Radius 30px", "crocal" ),
							'radius-35' => esc_html__( "Radius 35px", "crocal" ),
						),
						'title' => esc_html__( 'Radius', 'crocal' ),
						'default' => 'none',
					),
					array(
						'id' => 'product_overview_image_grayscale_effect',
						'type' => 'select',
						'options' => array(
							'none' => esc_html__( "None", "crocal" ),
							'grayscale-image' => esc_html__( "Grayscale Image", "crocal" ),
							'grayscale-image-hover' => esc_html__( "Colored on Hover", "crocal" ),
						),
						'title' => esc_html__( 'Grayscale Effect', 'crocal' ),
						'subtitle' => esc_html__( 'Choose the grayscale effect.', 'crocal' ),
						'default' => 'none',
					),
					array(
						'id' => 'product_overview_overlay_color',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'light',
					),
					array(
						'id' => 'product_overview_overlay_opacity',
						'type' => 'select',
						'options' => $crocal_eutf_opacity_selection_simple,
						'title' => esc_html__( 'Overlay Opacity', 'crocal' ),
						'subtitle' => esc_html__( 'Choose the opacity for the overlay.', 'crocal' ),
						'default' => '90',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Product Settings', 'crocal' ),
				'id' => 'eut_redux_section_single_product_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Products. Notice that most of them can be overridden when you create a single product.', 'crocal' ),
				'submenu' => true,
				'icon' => 'el-icon-shopping-cart',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Product Custom Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'product_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Product Custom Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'product_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Product Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Products. Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'product_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Products.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'product_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Product Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Product Sliding Area if you want.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'product_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Product Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id'   => 'info_style_product_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Product Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'crocal' ),
					),
					array(
						'id' => 'product_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your product header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'product_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Product Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Product Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single product.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_product_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Product Title Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default single product title.', 'crocal' ),
					),
					array(
						'id' => 'product_title_style',
						'type' => 'select',
						'default' => 'simple',
						'title' => esc_html__( 'Title Style', 'crocal' ),
						'subtitle' => esc_html__( 'Select Product Title Style', 'crocal' ),
						'options' => $crocal_eutf_title_style,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter product title height (Default is 60%).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter product title minimum height in px (Default is 200).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the default product title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'product_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the default product title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'product_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Product Title Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode,
						'default'  => 'color',
						'required' => array( 'product_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'product_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the default product title.', 'crocal' ),
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', 'equals', 'custom' ),
						),
					),
					array(
						'id' => 'product_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id' => 'product_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array(
							array( 'product_title_style', 'equals', 'advanced' ),
							array( 'product_title_bg_mode', '!=', 'color' ),
						),
					),
					array(
						'id'   => 'info_style_product_content_area',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Product Area/Product Content Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the product area and product content (Tabs).', 'crocal' ),
					),
					array(
						'id' => 'product_area_section_type',
						'type' => 'select',
						'title' => esc_html__( 'Product Area Full Width', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you prefer a full-width Product Content Area.', 'crocal' ),
						'options' => array(
							'fullwidth-background' => esc_html__( 'No', 'crocal' ),
							'fullwidth-element' => esc_html__( 'Yes', 'crocal' ),
						),
						'default' => 'fullwidth-background',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_area_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Area Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space above the area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_area_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Product Area bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space below the product area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Product Content Width', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Single Product Content width (only for Full Width Product Layout)', 'crocal' ),
						'options' => $crocal_eutf_container_size_selector,
						'default' => 'small',
					),
					array(
						'id'   => 'info_style_product_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per product.', 'crocal' ),
					),
					array(
						'id' => 'product_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'product_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in products.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'product_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'   => 'info_style_product_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'crocal' ),
					),
					array(
						'id'=>'product_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Product / Product Categories / Product Tags.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'product_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'product_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'product_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_product_image',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Product Image Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the single product image.', 'crocal' ),
					),
					array(
						'id' => 'product_image_thumb_style',
						'type' => 'select',
						'title' => esc_html__( 'Product Image / Thumbnails Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the style for the single product image and thumbnails. Note: some external plugins might not be compatible with Theme style.', 'crocal' ),
						'options' => array(
							'theme' => esc_html__( 'Theme Style', 'crocal' ),
							'woo' => esc_html__( 'Default WooCommerce Style', 'crocal' ),
						),
						'default' => 'theme',
					),
					array(
						'id' => 'product_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'crocal' ),
							'square' => esc_html__( 'Square Small Crop', 'crocal' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'crocal' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'crocal' ),
							'large' => esc_html__( 'Resize ( Large )', 'crocal' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
						),
						'title' => esc_html__( 'Product Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Choose the product image size.', 'crocal' ),
						'default' => 'default',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id' => 'product_thumbnails_columns',
						'type' => 'select',
						'options' => array(
							'3' => '3',
							'4' => '4',
							'5' => '5',
							'6' => '6',
						),
						'default' => '4',
						'title' => esc_html__( 'Product Thumbnails Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select the number of columns (Default is 4).', 'crocal' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id'=>'product_gallery_woo_zoom',
						'type' => 'switch',
						'title' => esc_html__( 'Zoom Effect', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable image zoom effect.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'product_gallery_woo_lightbox',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Lightbox', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery lightbox.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'product_gallery_woo_popup_thumbs',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Popup Thumbnails', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery popup thumbnails.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array(
							array( 'product_image_thumb_style', 'equals', 'theme' ),
							array( 'product_gallery_woo_lightbox', 'equals', '1' ),
						),
					),
					array(
						'id'=>'product_gallery_woo_slider',
						'type' => 'switch',
						'title' => esc_html__( 'Gallery Slider', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable gallery slider.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'woo' ),
					),
					array(
						'id' => 'product_gallery_title_caption',
						"type" => "select",
						"title" => esc_html__( "Product Gallery Image Title & Caption Visibility", "crocal" ),
						"subtitle" => esc_html__( "Define the visibility for your image title - caption.", "crocal" ),
						'options' => array(
							'none' => esc_html__( 'None' , 'crocal' ),
							'title-caption' => esc_html__( 'Title and Caption' , 'crocal' ),
							'title-only' => esc_html__( 'Title Only' , 'crocal' ),
							'caption-only' => esc_html__( 'Caption Only' , 'crocal' ),
						),
						'default' => 'none',
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id' => 'product_image_middle',
						'type' => 'switch',
						'title' => esc_html__( 'Product Image Middle Content', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable/Disable middle content for product image/thumbs and product summary.', 'crocal' ),
						'default' => 1,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'product_image_thumb_style', 'equals', 'theme' ),
					),
					array(
						'id'   => 'info_style_product_social',
						'type' => 'info',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Socials Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Socials.', 'crocal' ),
					),
					array(
						'id' => 'product_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'crocal' ),
						'subtitle' => esc_html__( 'Enable or Disable post social shares for the Single Product.', 'crocal' ),
						'options' => $crocal_eutf_product_social_options,
						'default' => 0,
					),
					array(
						'id'   => 'info_style_product_nav',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Navigation Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'crocal' ),
					),
					array(
						'id'=>'product_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Product Navigation Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the products navigation.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'product_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Product Navigation Same Term', 'crocal' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'crocal' ),
						'default' => 0,
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
					array(
						'id' => 'product_backlink_id',
						'type' => 'select',
						'title' => esc_html__( 'Product Backlink', 'crocal' ),
						'subtitle' => esc_html__( 'Select the overview page for your product backlink.', 'crocal' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'product_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'crocal' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'crocal' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'crocal'),
						'default'        => array(
							'padding-top'     => '60px',
							'padding-bottom'  => '60px',
							'units'           => 'px',
						),
						'required' => array( 'product_nav_visibility', 'equals', '1' ),
					),
				)
			);


			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-cog',
				'title' => esc_html__( 'External Plugin Support', 'crocal' ),
				'id' => 'eut_redux_section_external plugins',
				'submenu' => true,
				'customizer' => false,
				'fields' => array()
			);

			$this->sections[] = array(
				'icon' => 'el-icon-calendar',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Events Calendar Options', 'crocal'),
				'id' => 'eut_redux_section_event_calendar_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the Events Calendar here.', 'crocal' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'event_tax_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Taxonomy Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default layout for the Event Taxonomy. Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'event_tax_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Event Taxonomy.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'event_tax_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_tax_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Event Taxonomy.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_tax_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id'   => 'info_style_event_tax_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Event Taxonomy Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default Event Taxonomy header.', 'crocal' ),
					),
					array(
						'id' => 'event_tax_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your Event Taxonomy header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'event_tax_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Event Taxonomy Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Event Taxonomy Header overlaps the content. Combine this option with the Light or Dark Header.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_event_overview',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Event Overview Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the event overview.', 'crocal' ),
					),
					array(
						'id' => 'event_overview_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'crocal' ),
							'square' => esc_html__( 'Square Small Crop', 'crocal' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'crocal' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'crocal' ),
							'large' => esc_html__( 'Resize ( Large )', 'crocal' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
						),
						'title' => esc_html__( 'Event Overview Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Choose the event overview image size.', 'crocal' ),
						'default' => 'default',
					),
					array(
						'id' => 'event_overview_heading',
						'type' => 'select',
						'title' => esc_html__( 'Event Overview Title Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select size and typography for your event overview title.', 'crocal' ),
						'options' => $crocal_eutf_event_headings_selection,
						'default' => 'h2',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Single Event Settings', 'crocal' ),
				'id' => 'eut_redux_section_single_event_settings',
				'header' => '',
				'desc' => esc_html__( 'Define your preferences for the Single Events. Notice that most of them can be overridden when you create a single event.', 'crocal' ),
				'submenu' => true,
				'icon' => 'el-icon-calendar',
				'icon_class' => 'el-icon-large',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_padding_top_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Event Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space above the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_padding_top',
						'type' => 'text',
						'title' => esc_html__( 'Event Custom Top Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'event_padding_top_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_padding_bottom_multiplier',
						'type' => 'select',
						'title' => esc_html__( 'Event Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the space below the content area.', 'crocal' ),
						'options' => $crocal_eutf_padding_selection_extra,
						'default' => '3x',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_padding_bottom',
						'type' => 'text',
						'title' => esc_html__( 'Event Custom Bottom Padding', 'crocal' ),
						'subtitle'=> esc_html__( 'You can use px, em, %, etc. or enter just number and it will use pixels.', 'crocal' ),
						'required' => array( 'event_padding_bottom_multiplier', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Event Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the layout for the Single Events. Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'right',
					),
					array(
						'id' => 'event_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar for the Single Events.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'event_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Event Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Event Sliding Area if you want.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'event_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Event Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'event_content_width',
						'type' => 'select',
						'title' => esc_html__( 'Event Content Width', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Event Content width (only for Full Width Post Layout)', 'crocal' ),
						'options' => $crocal_eutf_container_size_selector,
						'default' => 'large',
					),
					array(
						'id'   => 'info_style_event_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Event Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default post header.', 'crocal' ),
					),
					array(
						'id' => 'event_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Event Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your event header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'event_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Event Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Event Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single event.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_event_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Event Title Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default single event title.', 'crocal' ),
					),
					array(
						'id' => 'event_title_style',
						'type' => 'select',
						'title' => esc_html__( 'Title Style', 'crocal' ),
						'subtitle' => esc_html__( 'Select Event Title Style', 'crocal' ),
						'options' => $crocal_eutf_title_style,
						'default' => 'advanced',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter event title height (Default is 60%).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Min Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter event title minimum height in px (Default is 200).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the default event title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the default event title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'event_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Event Title Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode,
						'default'  => 'color',
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id'       => 'event_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the default event title.', 'crocal' ),
						'required' => array( 'event_title_bg_mode', 'equals', 'custom' ),
						'required' => array( 'event_title_style', 'equals', 'advanced' ),
					),
					array(
						'id' => 'event_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'event_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'event_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_event_anchor_menu',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Anchor Menu Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Anchor Menu Bar where you can place a custom sticky menu per event.', 'crocal' ),
					),
					array(
						'id' => 'event_anchor_menu_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Anchor Menu Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Anchor Menu height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'event_anchor_menu_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Anchor Menu Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your Anchor Menu in events.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'event_anchor_menu_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to have full width Anchor Menu.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'   => 'info_style_event_breadcrumbs',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Breadcrumbs Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Breadcrumbs Bar.', 'crocal' ),
					),
					array(
						'id'=>'event_breadcrumbs_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Breadcrumbs', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Breadcrumbs for Single Event / Event Categories / Event Tags.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'event_breadcrumbs_height',
						'type' => 'text',
						'default' => '60',
						'title' => esc_html__( 'Breadcrumbs Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Breadcrumbs height in px (Default is 60).', 'crocal' ),
						'validate' => 'numeric',
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_breadcrumbs_alignment',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Breadcrumbs Alignment', 'crocal' ),
						'subtitle' => esc_html__( 'Select the alignment of your breadcrumbs.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'left',
						'validate' => 'not_empty',
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'event_breadcrumbs_fullwidth',
						'type' => 'switch',
						'title' => esc_html__( 'Fullwidth', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show your breadcrumbs full width.', 'crocal' ),
						'default' => 0,
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
						'required' => array( 'event_breadcrumbs_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_event_image',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Featured Image Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for event featured image', 'crocal' ),
					),
					array(
						'id' => 'event_image_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Event Featured Image Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle Featured Image on or off.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'event_image_size',
						'type' => 'select',
						'options' => array(
							'default' => esc_html__( 'Default', 'crocal' ),
							'square' => esc_html__( 'Square Small Crop', 'crocal' ),
							'landscape' => esc_html__( 'Landscape Small Crop', 'crocal' ),
							'landscape-large-wide' => esc_html__( 'Landscape Large Wide Crop', 'crocal' ),
							'portrait' => esc_html__( 'Portrait Small Crop', 'crocal' ),
							'extra-extra-large' => esc_html__( 'Resize ( Extra Extra Large )', 'crocal' ),
							'large' => esc_html__( 'Resize ( Large )', 'crocal' ),
							'medium_large' => esc_html__( 'Resize ( Medium Large )', 'crocal' ),
							'medium' => esc_html__( 'Resize ( Medium )', 'crocal' ),
						),
						'title' => esc_html__( 'Event Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Choose the event image size.', 'crocal' ),
						'default' => 'default',
						'required' => array( 'event_image_visibility', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_event_nav',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Navigation & Socials Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Define your preferences for the Navigation.', 'crocal' ),
					),
					array(
						'id'=>'event_nav_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Event Navigation Visibility', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the visibility of the events navigation.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'event_nav_same_term',
						'type' => 'checkbox',
						'title' => esc_html__( 'Event Navigation Same Term', 'crocal' ),
						'subtitle'=> esc_html__( 'If selected, only navigation items from the current taxonomy term will be displayed.', 'crocal' ),
						'default' => 0,
						'required' => array( 'event_nav_visibility', 'equals', '1' ),
					),
					array(
						'id'             => 'event_nav_spacing',
						'type'           => 'spacing',
						'mode'           => 'padding',
						'units'          => 'px',
						'units_extended' => 'false',
						'left'           => 'false',
						'right'          => 'false',
						'title'          => esc_html__( 'Navigation Bar Spacing', 'crocal' ),
						'subtitle'       => esc_html__( 'Set the spacing, Top and Bottom, of the Navigation Area.', 'crocal' ),
						'desc'           => esc_html__( 'Set spacing Top, Bottom in px.', 'crocal'),
						'default'        => array(
							'padding-top'     => '60px',
							'padding-bottom'  => '60px',
							'units'           => 'px',
						),
					),
					array(
						'id' => 'event_social',
						'type' => 'checkbox',
						'title' => esc_html__( 'Social Share', 'crocal' ),
						'subtitle' => esc_html__( 'Enable or Disable social shares for the Single Event.', 'crocal' ),
						'options' => $crocal_eutf_event_social_options,
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-comment-alt',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'bbPress Forum Options', 'crocal'),
				'id' => 'eut_redux_section_bbpress_options',
				'subtitle' => esc_html__( 'You can find the Theme settings for the bbPress here.', 'crocal' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'forum_layout',
						'type' => 'image_select',
						'compiler' => true,
						'title' => esc_html__( 'Forum Layout', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default layout for the Forum. Choose among Full Width, Left Sidebar or Right Sidebar.', 'crocal' ),
						'options' => $crocal_eutf_layout_selection,
						'default' => 'none',
					),
					array(
						'id' => 'forum_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the default sidebar for the single Forum.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id' => 'forum_fixed_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Fixed Sidebar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want a fixed sidebar.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'forum_sidearea_visibility',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sliding Area Visibility', 'crocal' ),
						'subtitle' => esc_html__( 'Enable the Sliding Area for the Forum.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id' => 'forum_sidearea_sidebar',
						'type' => 'select',
						'title' => esc_html__( 'Forum Sliding Area Sidebar', 'crocal' ),
						'subtitle' => esc_html__( 'Select the sidebar widget area for the sliding area.', 'crocal' ),
						'data' => 'sidebar',
						'default' => 'eut-default-sidebar',
					),
					array(
						'id'   => 'info_style_forum_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Forum Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default Forum header.', 'crocal' ),
					),
					array(
						'id' => 'forum_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Forum Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your Forum header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'default',
					),
					array(
						'id' => 'forum_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Forum Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Forum Header overlaps the content. Combine this option with the Light or Dark Header.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'no',
					),
					array(
						'id'   => 'info_style_forum_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Forum Title Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the single default Forum title.', 'crocal' ),
					),
					array(
						'id' => 'forum_title_height',
						'type' => 'select',
						'default' => '60',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Forum title height (Default is 60%).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_min_height',
						'type' => 'text',
						'default' => '320',
						'title' => esc_html__( 'Min Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter Forum title minimum height in px (Default is 320).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'forum_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the default Forum title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'forum_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the default Forum title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'forum_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Forum Title Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'forum_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the default Forum title.', 'crocal' ),
						'required' => array( 'forum_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'forum_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'forum_title_bg_mode', '!=', 'color' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Typography Options', 'crocal' ),
				'id' => 'eut_redux_section_typography_options',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Header/Body', 'crocal' ),
				'id' => 'eut_redux_section_typography_header',
				'header' => '',
				'desc' => esc_html__( 'Define your main typography settings.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_body_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Main Body Fonts', 'crocal' ),
					),
					array(
						'id' => 'body_font',
						'type' => 'typography',
						'title' => esc_html__( 'Body Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the body font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'default' => array(
							'font-size' => '16px',
							'line-height' => '30px',
							'font-family' => 'Nunito Sans',
							'font-weight' => '400',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'single_post_font',
						'type' => 'typography',
						'title' => esc_html__( 'Single Post & Product Body Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the single post & single product body font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height'=> true,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'default' => array(
							'font-size' => '16px',
							'line-height' => '30px',
							'font-family' => 'Nunito Sans',
							'font-weight' => '400',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_logo_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Logo as text Fonts', 'crocal' ),
					),
					array(
						'id' => 'logo_font',
						'type' => 'typography',
						'title' => esc_html__( 'Logo Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the logo font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height'=> false,
						'text-align'=> false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '36px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_menu_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Main Menu Fonts', 'crocal' ),
					),
					array(
						'id' => 'main_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the menu font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '15px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'megamenu_titles_font',
						'type' => 'typography',
						'title' => esc_html__( 'Megamenu Title Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the megamenu titles font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '16px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'sub_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Submenu Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the submenu font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '13px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'description_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Menu Description Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the Menu description font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '11px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_hidden_menu_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Hidden Menu Fonts', 'crocal' ),
					),
					array(
						'id' => 'hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Menu Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the hidden menu font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '18px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'sub_hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Submenu Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the hidden submenu font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'font-size' => '14px',
							'font-weight' => '500',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'description_hidden_menu_font',
						'type' => 'typography',
						'title' => esc_html__( 'Hidden Menu Description Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the hidden menu description font properties.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '11px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Headings (H1-H6)', 'crocal' ),
				'id' => 'eut_redux_section_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your Typography Headings ( H1-H6 ).', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_headers_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Headings Fonts', 'crocal' ),
					),
					array(
						'id' => 'h1_font',
						'type' => 'typography',
						'title' => esc_html__( 'H1 Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the H1 font.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '700',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'h2_font',
						'type' => 'typography',
						'title' => esc_html__( 'H2 Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the H2 font.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '42px',
							'line-height' => '48px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'h3_font',
						'type' => 'typography',
						'title' => esc_html__( 'H3 Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the H3 font.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '36px',
							'line-height' => '42px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'h4_font',
						'type' => 'typography',
						'title' => esc_html__( 'H4 Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the H4 font.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '30px',
							'line-height' => '36px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'h5_font',
						'type' => 'typography',
						'title' => esc_html__( 'H5 Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the H5 font.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '24px',
							'line-height' => '30px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'h6_font',
						'type' => 'typography',
						'title' => esc_html__( 'H6 Font', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the H6 font.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '18px',
							'line-height' => '24px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Titles/Descriptions', 'crocal' ),
				'id' => 'eut_redux_section_typography_titles',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for titles/descriptions.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_page_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Page/Blog Typography', 'crocal' ),
					),
					array(
						'id' => 'page_title',
						'type' => 'typography',
						'title' => esc_html__( 'Page Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the default page titles and for the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '800',
							'font-size' => '54px',
							'line-height' => '66px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'page_description',
						'type' => 'typography',
						'title' => esc_html__( 'Page Description', 'crocal' ),
						'subtitle' => esc_html__( 'Specify font for the page description and for the description of the assigned blog page in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. (Archives / Categories / Tags overview pages)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '16px',
							'line-height' => '30px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_post_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Single Post Typography', 'crocal' ),
					),
					array(
						'id' => 'post_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'Post Simple Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the single post simple title.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'font-size' => '36px',
							'line-height' => '42px',
							'font-weight' => '600',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'post_title',
						'type' => 'typography',
						'title' => esc_html__( 'Post Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the single post titles.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '500',
							'font-size' => '60px',
							'line-height' => '72px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'post_title_desc',
						'type' => 'typography',
						'title' => esc_html__( 'Post Description', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the single post description.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'post_title_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Meta', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for meta ( categories ) in the post title section.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'font-size' => '11px',
							'line-height' => '14px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1.5px',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'post_title_extra_meta',
						'type' => 'typography',
						'title' => esc_html__( 'Post Extra Meta', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for extra meta ( Author/Date/Comments ) in the post title section.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'font-size' => '14px',
							'line-height' => '19px',
							'font-weight' => '500',
							'text-transform' => 'capitalize',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_portfolio_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Portfolio Typography', 'crocal' ),
					),
					array(
						'id' => 'portfolio_title',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio titles.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '800',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'portfolio_description',
						'type' => 'typography',
						'title' => esc_html__( 'Portfolio Description', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the default single portfolio description.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_forum_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'bbPress Forum Typography', 'crocal' ),
					),
					array(
						'id' => 'forum_title',
						'type' => 'typography',
						'title' => esc_html__( 'Forum Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the forum titles.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'font-size' => '48px',
							'line-height' => '54px',
							'font-weight' => '800',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_woocommerce_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'WooCommerce Typography', 'crocal' ),
					),
					array(
						'id' => 'product_simple_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Product Simple Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the product simple title', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '36px',
							'line-height' => '42px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'product_short_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Product Short Description', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the product short description', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '16px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'product_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the product titles', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '800',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'product_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'WooCommerce Title Description', 'crocal' ),
						'subtitle' => esc_html__( 'Specify font for the product title description', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
										array(
						'id'   => 'info_events_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Events Calendar Typography', 'crocal' ),
					),
					array(
						'id' => 'event_tax_title',
						'type' => 'typography',
						'title' => esc_html__( 'Events Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the event titles', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'font-size' => '48px',
							'line-height' => '54px',
							'font-weight' => '800',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'event_tax_description',
						'type' => 'typography',
						'title' => esc_html__( 'Events Description', 'crocal' ),
						'subtitle' => esc_html__( 'Specify font for the events description', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=>false,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Feature Section', 'crocal' ),
				'id' => 'eut_redux_section_typography_feature_section',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for feature section.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_feature_typography_custom_height',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Feature Section Typography with Custom Height', 'crocal' ),
					),
					array(
						'id' => 'feature_subheading_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Sub Heading', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the sub-heading in the feature section.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '10px',
							'line-height' => '14px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'feature_title_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the title in the feature section.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'text-transform' => 'none',
							'font-weight' => '800',
							'font-size' => '48px',
							'line-height' => '54px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'feature_desc_custom_font',
						'type' => 'typography',
						'title' => esc_html__( 'Description', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the description in the feature section.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '30px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_feature_typography_full',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Feature Section Typography with Fullscreen mode', 'crocal' ),
					),
					array(
						'id' => 'feature_subheading_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Sub Heading', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the sub-heading in the feature section.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '12px',
							'line-height' => '16px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'feature_title_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the title in the feature section.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'font-size' => '72px',
							'line-height' => '78px',
							'font-weight' => '800',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'feature_desc_full_font',
						'type' => 'typography',
						'title' => esc_html__( 'Description', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the font for the  description in the feature section.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '30px',
							'line-height' => '36px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Extras', 'crocal' ),
				'id' => 'eut_redux_section_typography_extras',
				'header' => '',
				'desc' => esc_html__( 'Define your typography for extra fields ( widgets, special texts, custom fonts .etc ).', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-font',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'widgets_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Widgets Typography', 'crocal' ),
					),
					array(
						'id' => 'widget_title',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Title', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the style for the widget titles.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '20px',
							'line-height' => '24px',
							'font-weight' => '700',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'widget_text',
						'type' => 'typography',
						'title' => esc_html__( 'Widgets Text', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the style for the widget texts.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '14px',
							'line-height' => '28px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_special_typography',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Special Text Typography', 'crocal' ),
					),
					array(
						'id' => 'quote_text',
						'type' => 'typography',
						'title' => esc_html__( 'Quote Text', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the style for the quote text.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Roboto',
							'font-size' => '24px',
							'font-style' => 'italic',
							'line-height' => '36px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'leader_text',
						'type' => 'typography',
						'title' => esc_html__( 'Leader Text', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the style for the leader text. This is used in various elements (Text block, Testimonial...)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '24px',
							'line-height' => '36px',
							'font-weight' => '300',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'subtitle_text',
						'type' => 'typography',
						'title' => esc_html__( 'Subtitle Text', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the style for the subtitle text. This is used in various elements (Slogan Subtitle...)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '10px',
							'line-height' => '14px',
							'font-weight' => '700',
							'text-transform' => 'uppercase',
							'letter-spacing' => '1px',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'small_text',
						'type' => 'typography',
						'title' => esc_html__( 'Small Text', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the style for the small text. This is used in various elements (Tags, Post Meta...)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '14px',
							'line-height' => '26px',
							'font-weight' => '400',
							'text-transform' => 'none',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'link_text',
						'type' => 'typography',
						'title' => esc_html__( 'Link Text', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the style for the link text. This is used in various elements (Buttons, Read More...)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'font-size' => '14px',
							'font-weight' => '700',
							'text-transform' => 'capitalize',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'pagination_text',
						'type' => 'typography',
						'title' => esc_html__( 'Pagination Text', 'crocal' ),
						'subtitle' => esc_html__( 'Specify the pagination font.', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => true,
						'text-align' => false,
						'letter-spacing' => true,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'font-family' => 'Nunito Sans',
							'text-transform' => 'none',
							'font-weight' => '600',
							'font-size' => '18px',
							'line-height' => '24px',
							'letter-spacing' => '',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id'   => 'info_custom_font_family',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Custom Font Family', 'crocal' ),
					),
					array(
						'id' => 'custom_font_family_1',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 1', 'crocal' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'custom_font_family_2',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 2', 'crocal' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'custom_font_family_3',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 3', 'crocal' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
					array(
						'id' => 'custom_font_family_4',
						'type' => 'typography',
						'title' => esc_html__( 'Custom Font Family 4', 'crocal' ),
						'subtitle' => esc_html__( 'This is used in various elements (Title, Slogan, Callout...)', 'crocal' ),
						'google' => $crocal_is_google,
						'line-height' => false,
						'text-align' => false,
						'letter-spacing' => true,
						'font-size' => false,
						'color'=> false,
						'preview'=> true,
						'text-transform' => true,
						'default' => array(
							'text-transform' => 'none',
						),
						'fonts' => $crocal_eutf_std_fonts,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Typography', 'crocal' ),
				'id' => 'eut_redux_section_responsive_typography',
				'header' => '',
				'desc' => '',
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Headings', 'crocal' ),
				'id' => 'eut_redux_section_responsive_typography_headings',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness for the Typography Headings ( H1-H6 ).', 'crocal' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop_headings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'crocal' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape_headings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'crocal' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait_headings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'crocal' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile_headings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'crocal' ),
					),
					array(
						'id' => 'typography_mobile_threshold_headings',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio_headings',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.7',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive First Group', 'crocal' ),
				'id' => 'eut_redux_section_responsive_typography_first_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for the following elements: Page Title, Post Title, Portfolio Title, Product Title, Feature Section Title, Feature Section Description with Fullscreen mode.', 'crocal' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'crocal' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'crocal' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'crocal' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold',
						'type' => 'text',
						'default' => '20',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 20).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.85',
					),
					array(
						'id'   => 'info_typography_mobile',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'crocal' ),
					),
					array(
						'id' => 'typography_mobile_threshold',
						'type' => 'text',
						'default' => '18',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 18).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.6',
					),
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Responsive Second Group', 'crocal' ),
				'id' => 'eut_redux_section_responsive_typography_second_group',
				'header' => '',
				'desc' => esc_html__( 'Define your responsiveness Typography for the following elements: Page Description, Post Description, Portfolio Description, Product Description, Feature Section Description with Custom Height, Leader Text, Subtitle Text, Link Texts, Menus and Buttons.', 'crocal' ),
				'submenu' => true,
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-fontsize',
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'   => 'info_typography_small_desktop2',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Small Desktop', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 1201px) and (max-width: 1440px)', 'crocal' ),
					),
					array(
						'id' => 'typography_small_desktop_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_small_desktop_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '1',
					),
					array(
						'id'   => 'info_typography_tablet_landscape2',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Landscape', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 960px) and (max-width: 1200px)', 'crocal' ),
					),
					array(
						'id' => 'typography_tablet_landscape_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_landscape_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.9',
					),
					array(
						'id'   => 'info_typography_tablet_portrait2',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Tablet Portrait', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (min-width: 768px) and (max-width: 959px)', 'crocal' ),
					),
					array(
						'id' => 'typography_tablet_portrait_threshold2',
						'type' => 'text',
						'default' => '14',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 14).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_tablet_portrait_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.8',
					),
					array(
						'id'   => 'info_typography_mobile2',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Mobile', 'crocal' ),
						'subtitle'=> esc_html__( 'Screen (max-width: 767px)', 'crocal' ),
					),
					array(
						'id' => 'typography_mobile_threshold2',
						'type' => 'text',
						'default' => '13',
						'title' => esc_html__( 'Size Threshold', 'crocal' ),
						'subtitle' => esc_html__( 'Size threshold in px (Default is 13).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'typography_mobile_ratio2',
						'type' => 'select',
						'title' => esc_html__( 'Size Ratio', 'crocal' ),
						'subtitle'=> esc_html__( 'Select percentage of the original size.', 'crocal' ),
						'options' => $crocal_eutf_ratio_selection,
						'default' => '0.8',
					),
				),
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Top Bar', 'crocal' ),
				'id' => 'eut_redux_section_colors_top_bar',
				'desc' => esc_html__( 'Set your color preferences for the TopBar (you will see the changes in the live preview only if TopBar is enabled).', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					//Top Bar Color Settings
					array(
						'id'          => 'top_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your Top Bar.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Font Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Font color for your Top Bar.', 'crocal' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Link Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Link color for your Top Bar.', 'crocal' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'top_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Top Bar Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Hover color for your Top Bar.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Header / Menu', 'crocal' ),
				'id' => 'eut_redux_section_colors_header_menu',
				'desc' => esc_html__( 'Set your color preferences for the Header and Menu.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Default Header', 'crocal' ),
				'id' => 'eut_redux_section_colors_default_header',
				'desc' => esc_html__( 'Set your color preferences for the Default Header. Keep in mind that the basic settings for the Default Header are in Theme Options > Header Options.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Default Header Color Settings
					array(
						'id'       => 'default_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'default_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a border color for the header.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'default_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0',
					),
					//Menu Color Settings
					array(
						'id'          => 'default_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'crocal' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu type. This will affect if you select the button or underline type.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'default_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'crocal' ),
						'default'     => '#1e1e1e',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_text_bg_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Hover/Active Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a background color for the hover or active sub menu.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'crocal' ),
						'default'     => '#1e1e1e',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'crocal' ),
						'default'     => '#dbdcdd',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_label_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Label Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a background color for the label.', 'crocal' ),
						'default'     => '#454545',
						'transparent' => false,
					),
					array(
						'id'          => 'default_header_label_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Label Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a text color for the label.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Logo on Top Header', 'crocal' ),
				'id' => 'eut_redux_section_colors_logotop_header',
				'desc' => esc_html__( 'Set your color preferences for the Logo on top Header. Keep in mind that the basic settings for the Logo on top Header are in Theme Options > Header Options.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'logo_top_header_logo_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Logo Area Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the logo area.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_logo_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Logo Area Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the logo area.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'logo_top_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a border color for the header.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0.10',
					),
					array(
						'id'       => 'logo_top_header_menu_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Menu Area Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the menu area.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'logo_top_header_menu_area_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Menu Area Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the menu area.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '1',
					),
					//Menu Color Settings
					array(
						'id'          => 'logo_top_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'crocal' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu type. This will affect if you select the button or underline type.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'logo_top_header_submenu_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a background color for the sub menu.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'crocal' ),
						'default'     => '#777777',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_text_bg_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Hover/Active Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a background color for the hover or active sub menu.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_column_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu column titles ( Used in mega menu ).', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_column_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Column Titles Hover/Active Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu column titles ( Used in mega menu ).', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'logo_top_header_submenu_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Border Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a border color for the sub menu.', 'crocal' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Side Header', 'crocal' ),
				'id' => 'eut_redux_section_colors_side_header',
				'desc' => esc_html__( 'Set your color preferences for the Side Header. Keep in mind that the basic settings for the Side Header are in Theme Options > Header Options.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Logo on top Header Color Settings
					array(
						'id'       => 'side_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'crocal' ),
						'default'  => '#f7f7f7',
						'transparent' => false,
					),
					array(
						'id' => 'side_header_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '1',
					),
					//Menu Color Settings
					array(
						'id'          => 'side_header_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					//Sub Menu Color Settings
					array(
						'id'          => 'side_header_submenu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the sub menu text.', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_submenu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Sub Menu Text Hover/Active Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover or active sub menu text.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'side_header_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a border color.', 'crocal' ),
						'default'     => '#323232',
						'transparent' => false,
					),
					array(
						'id' => 'side_header_border_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the borders.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0.10',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sticky Header', 'crocal' ),
				'id' => 'eut_redux_section_colors_sticky_header',
				'desc' => esc_html__( 'Set your color preferences for the Sticky Header. You can enable/disable, select the type and logo for the sticky header in Theme Options > Header Options > Sticky Header Options.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Sticky Header Color Settings
					array(
						'id'       => 'header_sticky_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a background color for the header.', 'crocal' ),
						'default'  => '#101215',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '1',
					),
					array(
						'id'       => 'header_sticky_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a border color for the sticky header.', 'crocal' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id' => 'header_sticky_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the sticky header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0',
					),
					//Menu Color Settings
					array(
						'id'          => 'sticky_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'crocal' ),
						'default'     => '#9c9c9c',
						'transparent' => false,
					),
					array(
						'id'          => 'sticky_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover menu text.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_type_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'crocal' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'          => 'header_sticky_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'crocal' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Light Header', 'crocal' ),
				'id' => 'eut_redux_section_colors_light_header',
				'desc' => esc_html__( 'Notice that the Light Header is the transparent header with light fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'light_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'light_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'light_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'crocal' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'light_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a border color for the light header.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'light_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the light header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0',
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Dark Header', 'crocal' ),
				'id' => 'eut_redux_section_colors_dark_header',
				'desc' => esc_html__( 'Notice that the Dark Header is the transparent header with dark fonts that theme provides in order to combine with the overlapping option everywhere in your site.', 'crocal' ),
				'submenu' => false,
				'eut_colors' => true,
				'panel' => false,
				'subsection' => true,
				'fields' => array(
					//Menu Color Settings
					array(
						'id'          => 'dark_menu_text_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu text.', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'dark_menu_text_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Text Hover/Active Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the hover/active menu text.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'dark_menu_type_color_hover',
						'type'        => 'color',
						'title'       => esc_html__( 'Menu Type Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the menu type. This will affect if you select the button or underline type.', 'crocal' ),
						'default'     => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'dark_header_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a border color for the dark header.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'dark_header_border_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Border Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the border of the dark header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive Header', 'crocal' ),
				'id' => 'eut_redux_section_colors_responsive_header',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Header. These settings will affect when the responsive header appears, below 1024px.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_header_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the header.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_header_background_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Color Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the responsive header.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '1',
					),
					array(
						'id'          => 'responsive_header_elements_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements.', 'crocal' ),
						'default'     => '#838383',
						'transparent' => false,
					),
					array(
						'id'          => 'responsive_header_elements_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Header Elements Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for the header elements hover.', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Responsive / Hidden Menu', 'crocal' ),
				'id' => 'eut_redux_section_colors_responsive_menu',
				'desc' => esc_html__( 'Set your color preferences for the Responsive Menu. These settings will also affect for the hidden menu.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'responsive_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the responsive menu.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the responsive menu.', 'crocal' ),
						'default'  => '#2b2b2b',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the responsive menu.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_close_btn_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Close Button Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the close button of the responsive menu.', 'crocal' ),
						'default'  => '#2b2b2b',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the responsive menu.', 'crocal' ),
						'default'  => '#eef1f6',
						'transparent' => false,
					),
					array(
						'id'       => 'responsive_menu_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when responsive menu opens.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'responsive_menu_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when responsive menu opens.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0.90',
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Anchor Menu', 'crocal' ),
				'id' => 'eut_redux_section_colors_anchor_menu',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Anchor Menu in case you use one in any of your pages, posts items.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_anchor_menu_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background color for the Anchor Menu.', 'crocal' ),
						'default'  => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'crocal' ),
						'subtitle' => esc_html__( 'Font color for the Anchor Menu.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Hover color for the Anchor Menu.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_background_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Hover background color for the Anchor Menu.', 'crocal' ),
						'default'  => '#171a1d',
						'transparent' => false,
					),
					array(
						'id'       => 'page_anchor_menu_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Border color for the Anchor Menu.', 'crocal' ),
						'default'  => '#333638',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Main Content', 'crocal' ),
				'id' => 'eut_redux_section_colors_main_content',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the main content area of your site.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'body_heading_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Headings Text Color (h1-h6)', 'crocal' ),
						'subtitle'    => esc_html__( 'Pick a color for headings text.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the text.', 'crocal' ),
						'default'  => '#272727',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the links.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'       => 'body_text_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for hover text.', 'crocal' ),
						'default'  => '#5a4ee0',
						'transparent' => false,
					),
					array(
						'id'       => 'body_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a border color.', 'crocal' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'widget_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Widget Title Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for widget titles.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_1_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 1 Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for primary 1.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_2_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 2 Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for primary 2.', 'crocal' ),
						'default'  => '#1472DE',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_3_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 3 Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for primary 3.', 'crocal' ),
						'default'  => '#fe3956',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_4_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 4 Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for primary 4.', 'crocal' ),
						'default'  => '#f6f7fc',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_5_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 5 Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for primary 5.', 'crocal' ),
						'default'  => '#4882e3',
						'transparent' => false,
					),
					array(
						'id'       => 'body_primary_6_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Primary 6 Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for primary 6.', 'crocal' ),
						'default'  => '#db5111',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Blog /Post', 'crocal' ),
				'id' => 'eut_redux_section_colors_blog_post',
				'desc' => esc_html__( 'Set your color preferences for your Blog / Post.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Blog Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_blog_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the blog title area and the color of the blog title. These settings will only affect in case you have set a Static Page as blog page in Settings > Reading > Front Page Displays. Also these settings will also affect on Archives / Categories / Tags overview pages.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'blog_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your blog title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'blog_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#F8F8FB',
						'required' => array( 'blog_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'blog_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'blog_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your blog title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'blog_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'blog_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'blog_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your blog description.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'blog_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'blog_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_post_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single post title area and the color of the post title. Notice that you can disable it, override it or even use the feature section when you edit your single posts.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'post_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your post title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'post_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#F8F8FB',
						'required' => array( 'post_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'post_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_subheading_color',
						'type' => 'select',
						'title' => esc_html__( 'Categories/Meta Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your post categories/meta.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'post_subheading_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Meta Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'post_subheading_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your post title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'post_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'post_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'post_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your post description.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'dark',
					),
					array(
						'id'       => 'post_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'post_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Post Bar', 'crocal' ),
				'id' => 'eut_redux_section_colors_post_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single post.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'post_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background color for the post bar.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'crocal' ),
						'default'  => '#abaaff',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation borders.', 'crocal' ),
						'default'  => '#8785fc',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_backlink_background',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Backlink Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background Color for the Navigation Backlink.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'post_bar_backlink_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Backlink Icon Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Backlink icon.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Page', 'crocal' ),
				'id' => 'eut_redux_section_colors_page',
				'desc' => esc_html__( 'Set your color preferences for your page.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Page Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the predefined page title area and the color of the page title. Notice that you can disable it, override it or even use the feature section when you edit your single pages.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#14181a',
						'required' => array( 'page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'page_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'page_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Search Page', 'crocal' ),
				'id' => 'eut_redux_section_colors_search_page',
				'desc' => esc_html__( 'Set your color preferences for your search page.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Search Page Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_search_page_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the search page title area and the color of the page title.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'search_page_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your page title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'search_page_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#14181a',
						'required' => array( 'search_page_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'search_page_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'search_page_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your page title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'search_page_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'search_page_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your page description.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'search_page_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'search_page_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Portfolio', 'crocal' ),
				'id' => 'eut_redux_section_colors_portfolio',
				'desc' => esc_html__( 'Set your color preferences for your portfolio.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_portfolio_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single portfolio title area and the color of the portfolio title and description. Notice that you can disable it, override it or even use the feature section when you edit your single portfolio items.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'portfolio_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your portfolio title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'portfolio_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#14181a',
						'required' => array( 'portfolio_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'portfolio_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'portfolio_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your portfolio title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'portfolio_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'portfolio_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'portfolio_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your portfolio description.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'portfolio_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'portfolio_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Portfolio Bar', 'crocal' ),
				'id' => 'eut_redux_section_colors_portfolio_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single portfolio.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'portfolio_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background color for the portfolio bar.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation borders.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_backlink_background',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Backlink Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background Color for the Navigation Backlink.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'portfolio_bar_backlink_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Backlink Icon Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Backlink icon.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Shop/Product', 'crocal' ),
				'id' => 'eut_redux_section_colors_shop_product',
				'desc' => esc_html__( 'Set your color preferences for your Shop/Product.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Taxonomy Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_product_tax_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the product taxonomies title area and the color of the product taxonomies title and description.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_tax_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'product_tax_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#14181a',
						'required' => array( 'product_tax_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'product_tax_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_tax_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_tax_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_tax_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_tax_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_product_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single product title area and the color of the product title and description. Notice that you can disable it, override it or even use the feature section when you edit your single product items.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'product_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'product_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#14181a',
						'required' => array( 'product_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'product_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'product_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'product_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'product_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'product_description_color', 'equals', 'custom' ),
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Area', 'crocal' ),
				'id' => 'eut_redux_section_colors_product_area',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the single product content area. Notice that you can override it when you edit your single product items.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'          => 'product_area_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your Product Area.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Headings color for your Product Area.', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Font color for your Product Area.', 'crocal' ),
						'default'     => '#999999',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Link color for your Product Area.', 'crocal' ),
						'default'     => '#000000',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Hover color for your Product Area.', 'crocal' ),
						'default'     => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'          => 'product_area_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Border color for your Product Area.', 'crocal' ),
						'default'     => '#e0e0e0',
						'transparent' => false,
					),
					array(
						'id'=>'product_area_button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the color of your Product Area Buttons.', 'crocal' ),
						'options' => $crocal_eutf_button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'product_area_button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the hover color of your Product Area Buttons.', 'crocal' ),
						'options' => $crocal_eutf_button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Mini Cart', 'crocal' ),
				'id' => 'eut_redux_section_colors_mini_cart',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Mini Cart Area.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'mini_cart_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the mini cart area.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'mini_cart_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the mini cart area.', 'crocal' ),
						'default'  => '#808080',
						'transparent' => false,
					),
					array(
						'id'       => 'mini_cart_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the mini cart area.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'mini_cart_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the mini cart area.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'mini_cart_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the mini cart area.', 'crocal' ),
						'default'  => '#f1f1f1',
						'transparent' => false,
					),
					array(
						'id'       => 'mini_cart_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'mini_cart_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0.80',
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Product Bar', 'crocal' ),
				'id' => 'eut_redux_section_colors_product_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single product.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'product_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background color for the product bar.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation borders.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_backlink_background',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Backlink Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background Color for the Navigation Backlink.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'product_bar_backlink_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Backlink Icon Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Backlink icon.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Events Calendar', 'crocal' ),
				'id' => 'eut_redux_section_colors_events_calendar',
				'desc' => esc_html__( 'Set your color preferences for your Events.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_event_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the single event title area and the color of the event title and description. Notice that you can disable it, override it or even use the feature section when you edit your single event items.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'event_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'event_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#14181a',
						'required' => array( 'event_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'event_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'event_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#000000',
						'required' => array( 'event_title_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'event_description_color',
						'type' => 'select',
						'title' => esc_html__( 'Description Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your description.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'event_description_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Description Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#9B9B9B',
						'required' => array( 'event_description_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Event Bar', 'crocal' ),
				'id' => 'eut_redux_section_colors_event_bar',
				'header' => '',
				'desc' => esc_html__( 'Set the colors for the navigation - socials area in the single event.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id'       => 'event_bar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background color for the event bar.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_nav_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Titles Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Titles.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_arrow_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Arrows Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Arrows.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation borders.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_backlink_background',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Backlink Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background Color for the Navigation Backlink.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'event_bar_backlink_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Navigation Backlink Icon Color', 'crocal' ),
						'subtitle' => esc_html__( 'Color for the Navigation Backlink icon.', 'crocal' ),
						'default'  => '#141414',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - bbPress Forum', 'crocal' ),
				'id' => 'eut_redux_section_colors_bbpress',
				'desc' => esc_html__( 'Set your color preferences for your Forum.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Forum Title', 'crocal' ),
				'id' => 'eut_redux_section_colors_forum_title',
				'header' => '',
				'desc' => esc_html__( 'Set the background color for the forum title area.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					array(
						'id' => 'forum_title_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your title.', 'crocal' ),
						'options' => $crocal_eutf_bg_color_selection_extra,
						'default' => 'custom',
					),
					array(
						'id'       => 'forum_title_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#14181a',
						'required' => array( 'forum_title_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_content_bg_color',
						'type' => 'select',
						'title' => esc_html__( 'Content Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background Color for your title content.', 'crocal' ),
						'options' => $crocal_eutf_content_bg_color_selection_extra,
						'default' => 'none',
					),
					array(
						'id'       => 'forum_title_content_bg_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Content Background Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'forum_title_content_bg_color', 'equals', 'custom' ),
					),
					array(
						'id' => 'forum_title_color',
						'type' => 'select',
						'title' => esc_html__( 'Title Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Color for your title.', 'crocal' ),
						'options' => $crocal_eutf_color_selection_extra,
						'default' => 'light',
					),
					array(
						'id'       => 'forum_title_color_custom',
						'type'     => 'color',
						'title'    => esc_html__( 'Custom Title Color', 'crocal' ),
						'transparent' => false,
						'default'  => '#ffffff',
						'required' => array( 'forum_title_color', 'equals', 'custom' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Footer', 'crocal' ),
				'id' => 'eut_redux_section_colors_footer',
				'desc' => esc_html__( 'Set your color preferences for your Footer.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
				),
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Area', 'crocal' ),
				'id' => 'eut_redux_section_colors_footer_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Area. Define the Footer Area in Theme Options > Footer Options.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Area Color Settings
					array(
						'id'          => 'footer_widgets_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Area.', 'crocal' ),
						'default'     => '#14181a',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_headings_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Headings Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Headings color for your Footer Area.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Area.', 'crocal' ),
						'default'     => '#808080',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Area.', 'crocal' ),
						'default'     => '#808080',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Area.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_widgets_border_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Border Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Border color for your Footer Area.', 'crocal' ),
						'default'     => '#1E1E1E',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Footer Bar Area', 'crocal' ),
				'id' => 'eut_redux_section_colors_footer_bar_area',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Footer Bar Area(copyright area). Define the Footer Bar Area in Theme Options > Footer Options.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => true,
				'fields' => array(
					//Footer Bar Color Settings
					array(
						'id'          => 'footer_bar_bg_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Background Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Background color for your Footer Bar Area.', 'crocal' ),
						'default'     => '#14181a',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_bg_color_opacity',
						'type'        => 'select',
						'title'       => esc_html__('Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for your Footer Bar Area.', 'crocal' ),
						'options'     => $crocal_eutf_opacity_selection,
						"default"     => '1',
					),
					array(
						'id'          => 'footer_bar_font_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Font Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Font color for your Footer Bar Area.', 'crocal' ),
						'default'     => '#cecece',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_link_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Link Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Link color for your Footer Bar Area.', 'crocal' ),
						'default'     => '#cecece',
						'transparent' => false,
					),
					array(
						'id'          => 'footer_bar_hover_color',
						'type'        => 'color',
						'title'       => esc_html__( 'Hover Color', 'crocal' ),
						'subtitle'    => esc_html__( 'Hover color for your Footer Bar Area.', 'crocal' ),
						'default'     => '#ffffff',
						'transparent' => false,
					),
				)
			);
			$this->sections[] = array(
				'title' => esc_html__( 'Colors - Breadcrumbs', 'crocal' ),
				'id' => 'eut_redux_section_colors_breadcrumbs',
				'header' => '',
				'desc' => esc_html__( 'Set your color preferences for the Breadcrumbs in case you use then in any of your pages, posts or items.', 'crocal' ),
				'icon_class' => 'el-icon-large',
				'icon' => 'el-icon-brush',
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'page_breadcrumbs_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Background color for the Breadcrumbs.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Font Color', 'crocal' ),
						'subtitle' => esc_html__( 'Font color for the Breadcrumbs.', 'crocal' ),
						'default'  => '#6e6e6e',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_text_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Hover color for the Breadcrumbs.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_divider_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Divider Color', 'crocal' ),
						'subtitle' => esc_html__( 'Divider color for the Breadcrumbs.', 'crocal' ),
						'default'  => '#b2b2b2',
						'transparent' => false,
					),
					array(
						'id'       => 'page_breadcrumbs_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Border color for the Breadcrumbs.', 'crocal' ),
						'default'  => '#e0e0e0',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Sliding Area', 'crocal' ),
				'id' => 'eut_redux_section_colors_sliding_area',
				'desc' => esc_html__( 'Set your color preferences for the Sliding Area.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'sliding_area_icon_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Icon Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the sliding area icon.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_shape_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Icon Shape Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the sliding area shape.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id' => 'sliding_area_bg_type',
						'type' => 'select',
						'title' => esc_html__( 'Background Type', 'crocal' ),
						'subtitle'=> esc_html__( 'Select a background type for the sliding area.', 'crocal' ),
						'options' => array(
							'color' => esc_html__( 'Color', 'crocal' ),
							'gradient' => esc_html__( 'Gradient', 'crocal' ),
						),
						'default' => 'gradient',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'sliding_area_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the sliding area.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
						'required' => array( 'sliding_area_bg_type', 'equals', 'color' ),
					),
					array(
						'id'       => 'sliding_area_gradient_color_1',
						'type'     => 'color',
						'title'    => esc_html__( 'Gradient Color 1', 'crocal' ),
						'default'  => '#ff9966',
						'transparent' => false,
						'required' => array( 'sliding_area_bg_type', 'equals', 'gradient' ),
					),
					array(
						'id'       => 'sliding_area_gradient_color_2',
						'type'     => 'color',
						'title'    => esc_html__( 'Gradient Color 2', 'crocal' ),
						'default'  => '#ff5e62',
						'transparent' => false,
						'required' => array( 'sliding_area_bg_type', 'equals', 'gradient' ),
					),
					array(
						'id' => 'sliding_area_gradient_direction',
						'type' => 'select',
						'title' => esc_html__( 'Gradient Direction', 'crocal' ),
						'options' => array(
							'90' => esc_html__( 'Left to Right', 'crocal' ),
							'135' => esc_html__( 'Left Top to Right Bottom', 'crocal' ),
							'45' => esc_html__( 'Left Bottom to Right Top', 'crocal' ),
							'180' => esc_html__( 'Top to Bottom', 'crocal' ),
						),
						'default' => '135',
						'validate' => 'not_empty',
						'required' => array( 'sliding_area_bg_type', 'equals', 'gradient' ),
					),

					array(
						'id'       => 'sliding_area_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the sliding area.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the sliding area.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_link_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Link Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the links of the sliding area.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_link_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the hovers of the sliding area.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'       => 'sliding_area_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the sliding area.', 'crocal' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Modals', 'crocal' ),
				'id' => 'eut_redux_section_colors_modals',
				'desc' => esc_html__( 'Set your color preferences for the Modals.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'modal_title_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Title Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the titles - headings (h1-h6) of the modal.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_text_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the text of the modal.', 'crocal' ),
						'default'  => '#777777',
						'transparent' => false,
					),
					array(
						'id' => 'modal_cursor_color_color',
						'type' => 'select',
						'title' => esc_html__( 'Navigation - Close Buttons Color', 'crocal' ),
						'subtitle'=> esc_html__( 'Select a color for the navigation and close buttons of the modal.', 'crocal' ),
						'options' => array(
							'dark' => esc_html__( 'Dark', 'crocal' ),
							'light' => esc_html__( 'Light', 'crocal' ),
						),
						'default' => 'dark',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'modal_border_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Border Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the borders of the modal.', 'crocal' ),
						'default'  => '#e9e9e9',
						'transparent' => false,
					),
					array(
						'id'       => 'modal_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when modal opens.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id' => 'modal_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Overflow Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the overflow area, when modal opens.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '1',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Media Popup', 'crocal' ),
				'id' => 'eut_redux_section_colors_media_popup',
				'desc' => esc_html__( 'Set your color preferences for yor Media Popups.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'       => 'media_popup_overflow_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Overflow Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the overflow area, when popup opens.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'media_popup_overflow_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the overflow area.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0.90',
					),
					array(
						'id'       => 'media_popup_toolbar_background_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Toolbar/ Navigation Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a background color for the toolbar area, navigation buttons.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'media_popup_toolbar_background_color_opacity',
						'type' => 'select',
						'title' => esc_html__('Toolbar/ Navigation Background Opacity', 'crocal' ),
						'subtitle'    => esc_html__( 'Select opacity for the background of the toolbar area, navigation buttons.', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						"default" => '0.45',
					),
					array(
						'id'       => 'media_popup_toolbar_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Toolbar/ Navigation Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for the toolbar area, navigation buttons.', 'crocal' ),
						'default'  => '#999',
						'transparent' => false,
					),
					array(
						'id'       => 'media_popup_toolbar_hover_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Toolbar/ Navigation Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a hover color for the toolbar area, navigation buttons.', 'crocal' ),
						'default'  => '#fff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Back to Top', 'crocal' ),
				'id' => 'eut_redux_section_colors_back_to_top',
				'desc' => esc_html__( 'Set your color preferences for Back to Top.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'back_to_top_icon_color',
						'type' => 'color',
						'title' => esc_html__( 'Back to Top Icon Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top icon.', 'crocal' ),
						'default'  => '#4ea4bf',
						'transparent' => false,
					),
					array(
						'id'=>'back_to_top_shape_color',
						'type' => 'color',
						'title' => esc_html__( 'Back to Top Icon Shape Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the color of Back to Top shape.', 'crocal' ),
						'default' => '#ffffff',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-brush',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Colors - Privacy / Cookies', 'crocal' ),
				'id' => 'eut_redux_section_colors_privacy_consent_bar',
				'desc' => esc_html__( 'Set your color preferences for Privacy / Cookies feature.', 'crocal' ),
				'submenu' => false,
				'panel' => false,
				'eut_colors' => true,
				'subsection' => false,
				'fields' => array(
					array(
						'id'=>'privacy_bar_bg_color',
						'type' => 'color',
						'title' => esc_html__( 'Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the background color of Privacy Consent Info Bar.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
					),
					array(
						'id' => 'privacy_bar_bg_opacity',
						'type' => 'select',
						'title' => esc_html__( 'Background Opacity', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0.90',
					),
					array(
						'id'=>'privacy_bar_text_color',
						'type' => 'color',
						'title' => esc_html__( 'Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the color of Privacy Consent Info Bar Text.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_text_color',
						'type' => 'color',
						'title' => esc_html__( 'Button Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the color of Privacy Consent Info Bar Button Text.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_bg_color',
						'type' => 'color',
						'title' => esc_html__( 'Button Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the background color of Privacy Consent Info Bar Button.', 'crocal' ),
						'default'  => '#2bc137',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_bar_button_bg_hover_color',
						'type' => 'color',
						'title' => esc_html__( 'Button Background Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the background hover color of Privacy Consent Info Bar Button.', 'crocal' ),
						'default'  => '#17a523',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_text_color',
						'type' => 'color',
						'title' => esc_html__( 'Modal Button Text Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the color of Modal Button Text.', 'crocal' ),
						'default'  => '#ffffff',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_bg_color',
						'type' => 'color',
						'title' => esc_html__( 'Modal Button Background Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the background color of Modal Button.', 'crocal' ),
						'default'  => '#2bc137',
						'transparent' => false,
					),
					array(
						'id'=>'privacy_modal_button_bg_hover_color',
						'type' => 'color',
						'title' => esc_html__( 'Modal Button Background Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the background hover color of Modal Button.', 'crocal' ),
						'default'  => '#17a523',
						'transparent' => false,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Social Media', 'crocal' ),
				'id' => 'eut_redux_section_social_media',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'social_options',
						'type' => 'sortable',
						'title' => esc_html__( 'Social URLs', 'crocal' ),
						'subtitle' => esc_html__( 'Define and reorder your social URLs. Clear the input field for any social link you do not wish to display.', 'crocal' ),
						'desc' => '',
						'label' => true,
						'options' => $crocal_eutf_social_options,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cloud',
				'icon_class' => 'el-icon-cog',
				'title' => esc_html__( 'Utilities', 'crocal' ),
				'id' => 'eut_redux_section_utilities',
				'submenu' => true,
				'customizer' => false,
				'fields' => array()
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cogs',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Theme Performance', 'crocal' ),
				'id' => 'eut_redux_section_advanced',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
 					array(
						'id'=>'combine_js',
						'type' => 'select',
						'title' => esc_html__( 'Combine/Compress Theme Scripts', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to combine/compress theme scripts.', 'crocal' ),
						'options' => array(
							'1' => esc_html__( 'Partial merge/compression of theme javascript files', 'crocal' ),
							'0' => esc_html__( 'No merge/compression of theme javascript files', 'crocal' ),
						),
						"default" => '1',
					),
					array(
						'id'=>'css_generation',
						'type' => 'switch',
						'title' => esc_html__( 'Generate Theme Options dynamic css in a file', 'crocal' ),
						'subtitle'=> esc_html__( 'Switch this option to On to save dynamic css in a file.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-resize-small',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Media Options', 'crocal' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'image_load_mode',
						'type' => 'select',
						'title' => esc_html__( 'Image Load Mode', 'crocal' ),
						'subtitle' => esc_html__( 'Enable Lazy load.', 'crocal' ),
						'options' => array(
							'default' => esc_html__( 'Default', 'crocal' ),
							'lazyload' => esc_html__( 'Lazyload', 'crocal' ),
						),
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'feature_section_bg_size',
						'type' => 'select',
						'title' => esc_html__( 'Feature Section Background Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select what background image to show for Feture Sections.', 'crocal' ),
						'options' => array(
							'responsive' => esc_html__( 'Responsive', 'crocal' ),
							'extra-extra-large' => esc_html__( 'Extra Extra Large', 'crocal' ),
							'full' => esc_html__( 'Full', 'crocal' ),
						),
						'default' => 'responsive',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'row_section_bg_size',
						'type' => 'select',
						'title' => esc_html__( 'Row Section Background Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select what background image to show for Row Sections.', 'crocal' ),
						'options' => array(
							'responsive' => esc_html__( 'Responsive', 'crocal' ),
							'extra-extra-large' => esc_html__( 'Extra Extra Large', 'crocal' ),
							'full' => esc_html__( 'Full', 'crocal' ),
						),
						'default' => 'responsive',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'placeholder_mode',
						'type' => 'select',
						'title' => esc_html__( 'Placeholder Mode', 'crocal' ),
						'subtitle' => esc_html__( 'Select what images to display as placeholders.', 'crocal' ),
						'options' => array(
							'dummy' => esc_html__( 'Theme Dummy Image', 'crocal' ),
							'unsplash' => esc_html__( 'unsplash', 'crocal' ),
							//'placehold' => esc_html__( 'placehold.it', 'crocal' ),
						),
						'default' => 'dummy',
						'validate' => 'not_empty',
					),
					array(
						'id'   => 'info_settings_media_sizes',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Media Sizes', 'crocal' ),
						'subtitle' => esc_html__( 'These settings affect the display and dimensions of images in the Theme. After changing these settings you may need to', 'crocal' ) . " "  . $regenerate_link . ".",
					),

					array(
						'id'       => 'size_large_landscape_wide',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Landscape Wide Large', 'crocal'),
						'subtitle'=> esc_html__( 'Default 1390x782 - 16:9 ratio (Cropped)', 'crocal' ),
						'default'  => array(
							'width'   => '1390',
							'height'  => '782'
						),
						'validate_callback' => 'crocal_eutf_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_landscape',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Landscape', 'crocal'),
						'subtitle'=> esc_html__( 'Default 560x420 - 4:3 ratio (Cropped)', 'crocal' ),
						'default'  => array(
							'width'   => '560',
							'height'  => '420'
						),
						'validate_callback' => 'crocal_eutf_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_portrait',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Portrait', 'crocal'),
						'subtitle'=> esc_html__( 'Default 560x747 - 3:4 ratio (Cropped)', 'crocal' ),
						'default'  => array(
							'width'   => '560',
							'height'  => '747'
						),
						'validate_callback' => 'crocal_eutf_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_small_square',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Square', 'crocal'),
						'subtitle'=> esc_html__( 'Default 560x560 - 1:1 ratio (Cropped)', 'crocal' ),
						'default'  => array(
							'width'   => '560',
							'height'  => '560'
						),
						'validate_callback' => 'crocal_eutf_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_medium_landscape',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Landscape Large', 'crocal'),
						'subtitle'=> esc_html__( 'Default 900x675 - 4:3 ratio (Cropped)', 'crocal' ),
						'default'  => array(
							'width'   => '900',
							'height'  => '675'
						),
						'validate_callback' => 'crocal_eutf_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_medium_portrait',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Portrait Large', 'crocal'),
						'subtitle'=> esc_html__( 'Default 840x1120 - 3:4 ratio (Cropped)', 'crocal' ),
						'default'  => array(
							'width'   => '840',
							'height'  => '1120'
						),
						'validate_callback' => 'crocal_eutf_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_medium_square',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Square Large', 'crocal'),
						'subtitle'=> esc_html__( 'Default 900x900 - 1:1 ratio (Cropped)', 'crocal' ),
						'default'  => array(
							'width'   => '900',
							'height'  => '900'
						),
						'validate_callback' => 'crocal_eutf_redux_dimensions_validation',
					),
					array(
						'id'       => 'size_fullscreen',
						'type'     => 'dimensions',
						'units'    => false,
						'title'    => esc_html__('Fullscreen', 'crocal'),
						'subtitle'=> esc_html__( 'Default 1920x1920 (Resize)', 'crocal' ),
						'default'  => array(
							'width'   => '1920',
							'height'  => '1920'
						),
						'validate_callback' => 'crocal_eutf_redux_dimensions_validation',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-search',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Search Options', 'crocal'),
				'id' => 'eut_redux_section_search_page_options',
				'subtitle' => esc_html__( 'You can find the basic settings for the search page here.', 'crocal' ),
				'desc' => esc_html__( 'You can find the basic settings for the search page here.', 'crocal' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'   => 'info_style_search_page_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Search Page Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the search page header.', 'crocal' ),
					),
					array(
						'id' => 'search_page_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'light',
					),
					array(
						'id' => 'search_page_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id'   => 'info_style_search_page_title',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Search Page Title Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the search page title.', 'crocal' ),
					),
					array(
						'id' => 'search_page_title_height',
						'type' => 'select',
						'default' => 'large',
						'title' => esc_html__( 'Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter page title height (Default is Large Height).', 'crocal' ),
						'options' => $crocal_eutf_area_height,
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_min_height',
						'type' => 'text',
						'default' => '200',
						'title' => esc_html__( 'Minimum Height', 'crocal' ),
						'subtitle' => esc_html__( 'Enter page title minimum height in px (Default is 200).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_title_container_size',
						'type' => 'select',
						'title' => esc_html__( 'Container Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the container.', 'crocal' ),
						'options' => $crocal_eutf_container_size_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_size',
						'type' => 'select',
						'title' => esc_html__( 'Content Size', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the size of the content.', 'crocal' ),
						'options' => $crocal_eutf_content_size_selection,
						'default' => 'large',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_alignment',
						'type' => 'select',
						'title' => esc_html__( 'Content Alignment', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the alignment of the content.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_extra,
						'default' => 'center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_position',
						'type' => 'select',
						'title' => esc_html__( 'Content Position', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your position for the search page title/description.', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'search_page_title_content_animation',
						'type' => 'select',
						'title' => esc_html__( 'Content Animation', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your animation for the search page title/description.', 'crocal' ),
						'options' => $crocal_eutf_animation_selection,
						'default' => 'fade-in-up',
						'validate' => 'not_empty',
					),
					array(
						'id'       => 'search_page_title_bg_mode',
						'type'     => 'select',
						'title' => esc_html__( 'Background Mode', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the Page Title Background, Color or Image.', 'crocal' ),
						'options' => $crocal_eutf_title_bg_mode_limited,
						'default'  => 'color',
					),
					array(
						'id'       => 'search_page_title_bg_image',
						'type'     => 'media',
						'title' => esc_html__( 'Background Image', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image for the search page title.', 'crocal' ),
						'required' => array( 'search_page_title_bg_mode', 'equals', 'custom' ),
					),
					array(
						'id' => 'search_page_title_bg_position',
						'type' => 'select',
						'title' => esc_html__( 'Background Position', 'crocal' ),
						'options' => $crocal_eutf_align_selection_full,
						'default' => 'center-center',
						'validate' => 'not_empty',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_pattern_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Pattern Overlay', 'crocal' ),
						'options' => $crocal_eutf_pattern_selection,
						'default' => 'none',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_color_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Color Overlay', 'crocal' ),
						'options' => $crocal_eutf_color_selection,
						'default' => 'dark',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id' => 'search_page_title_opacity_overlay',
						'type' => 'select',
						'title' => esc_html__( 'Opacity Overlay', 'crocal' ),
						'options' => $crocal_eutf_opacity_selection,
						'default' => '0',
						'required' => array( 'search_page_title_bg_mode', '!=', 'color' ),
					),
					array(
						'id'   => 'info_style_search_page_settings',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Search Page Style and Basic Search Page Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style and basic settings for the search page.', 'crocal' ),
					),
					array(
						'id' => 'search_page_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mode', 'crocal' ),
						'subtitle' => esc_html__( 'Select the search page mode', 'crocal' ),
						'options' => array(
							'masonry' => esc_html__( 'Masonry' , 'crocal' ),
							'grid' => esc_html__( 'Grid' , 'crocal' ),
							'small' => esc_html__( 'Small Media', 'crocal' ),
						),
						'default' => 'masonry',
					),
					array(
						'id' => 'search_page_shadow_style',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Style', 'crocal' ),
						'subtitle' => esc_html__( 'Select the search style', 'crocal' ),
						'options' =>array(
							'shadow-mode' => esc_html__( 'With Shadow', 'crocal' ),
							'no-shadow-mode' => esc_html__( 'Without Shadow', 'crocal' ),
						),
						'default' => 'shadow-mode',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_show_image',
						'type' => 'select',
						'title' => esc_html__( 'Show Search Page Featured Image', 'crocal' ),
						'subtitle' => esc_html__( 'If enabled, Featured image is displayed', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'yes',
					),
					array(
						'id' => 'search_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Grid Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select your Search Grid Image Size', 'crocal' ),
						'options' => $crocal_eutf_search_grid_image_mode_selection,
						'default' => 'landscape',
						'required' => array(
							array( 'search_page_mode', '!=', 'masonry' ),
							array( 'search_page_show_image', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'search_masonry_image_mode',
						'type' => 'select',
						'title' => esc_html__( 'Search Masonry Image Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select your Search Masonry Image Size', 'crocal' ),
						'options' => $crocal_eutf_search_masonry_image_mode_selection,
						'default' => 'medium',
						'required' => array(
							array( 'search_page_mode','equals', 'masonry' ),
							array( 'search_page_show_image', 'equals', 'yes' ),
						),
					),
					array(
						'id' => 'search_page_columns_large_screen',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Large Screen Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns on large screen devices', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection,
						'default' => '3',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select the Search Page Columns', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection,
						'default' => '3',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_tablet_landscape',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Landscape Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, landscape orientation.', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_tablet_portrait',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Tablet Portrait Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select responsive column on tablet devices, portrait orientation.', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection_tablet,
						'default' => '2',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						'id' => 'search_page_columns_mobile',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Mobile Columns', 'crocal' ),
						'subtitle' => esc_html__( 'Select responsive column on mobile devices.', 'crocal' ),
						'options' => $crocal_eutf_blog_columns_selection_mobile,
						'default' => '1',
						'required' => array( 'search_page_mode', '!=', 'small' ),
					),
					array(
						"id" => "search_display_style",
						"type" => "select",
						"title" => esc_html__( "Display Style", "crocal"),
						"subtitle" => esc_html__("Define your pagination style.", "crocal" ),
						"options" => array(
							'pagination' => esc_html__( "Pagination", "crocal" ),
							"load-more" => esc_html__( "Load More", "crocal" ),
							"infinite-scroll" => esc_html__( "Infinite Scroll", "crocal" ),
						),
						'default' => 'pagination',
					),
					array(
						'id'=>'search_load_more_title',
						'type' => 'text',
						'default' => 'Load More',
						'title' => esc_html__( 'Load More Title', 'crocal' ),
						'subtitle' => esc_html__( 'Title for load more.', 'crocal' ),
						'required' => array( 'search_display_style', 'equals', 'load-more' ),
					),
					array(
						'id' => 'search_page_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Tag', 'crocal' ),
						'subtitle' => esc_html__( 'Select tag for your search result title.', 'crocal' ),
						'options' => $crocal_eutf_headings_tag_selection,
						'default' => 'h4',
					),
					array(
						'id' => 'search_page_heading',
						'type' => 'select',
						'title' => esc_html__( 'Search Page Result Title Size', 'crocal' ),
						'subtitle' => esc_html__( 'Select size and typography for your search result title.', 'crocal' ),
						'options' => $crocal_eutf_headings_selection,
						'default' => 'h4',
					),
					array(
						'id'=>'search_page_excerpt_length_small',
						'type' => 'text',
						'default' => '30',
						'title' => esc_html__( 'Excerpt Length', 'crocal' ),
						'subtitle' => esc_html__( 'Type how many words you want to display in your post excerpts (Default is 30).', 'crocal' ),
						'validate' => 'numeric',
					),
					array(
						'id' => 'search_page_excerpt_more',
						'type' => 'switch',
						'title' => esc_html__( 'Read More', 'crocal' ),
						'subtitle'=> esc_html__( "Adds a read more button after the excerpt or more quicktag.", 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id' => 'search_modal_text',
						'type' => 'text',
						'title' => esc_html__( 'Search Modal Text', 'crocal' ),
						'subtitle' => esc_html__( 'Type the search text of the modal.', 'crocal' ),
						'default' => 'Start Typing',
					),
					array(
						'id' => 'search_modal_button_text',
						'type' => 'text',
						'title' => esc_html__( 'Search Modal Button Text', 'crocal' ),
						'subtitle' => esc_html__( 'Type the search text of the modal button.', 'crocal' ),
						'default' => 'Start Searching',
					),
					array(
						'id' => 'search_page_not_found_text',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Search Page Not Found Content', 'crocal' ),
						'subtitle' => esc_html__( 'Type the content of your search page when no results are found.', 'crocal' ),
						'default' => '<h3 class="eut-align-center eut-subtitle-text">Maybe you should check again your spelling.</h3><h3 class="eut-align-center">This is not the page you are looking for...</h3>',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-map-marker',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Map Options', 'crocal' ),
				'id' => 'eut_redux_section_map_options',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'map_api_mode',
						'type' => 'button_set',
						'title' => esc_html__( 'Map API', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the map API', 'crocal' ),
						'options' => array(
							'google-maps' => esc_html__( 'Google Maps', 'crocal' ),
							'openstreetmap' => esc_html__( 'OpenStreetMap', 'crocal' ),
						),
						'default' => 'google-maps',
					),
					array(
						'id'=>'map_tile_url',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer URL', 'crocal' ),
						'subtitle' => esc_html__( 'Define the Tile Layer. Used to load and display tile layers on the map.', 'crocal' ),
						'desc' => sprintf( '%1$s: <a href="//wiki.openstreetmap.org/wiki/Tile_servers" target="_blank"> %2$s </a>', esc_html__('See more tile servers', 'crocal'), esc_html__('here', 'crocal') ),
						"default" => 'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'=>'map_tile_url_subdomains',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer Subdomains', 'crocal' ),
						'subtitle'=> esc_html__( 'Define the Tile Layer subdomains.', 'crocal' ),
						"default" => "abc",
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'=>'map_tile_attribution',
						'type' => 'text',
						'title' => esc_html__( 'Tile Layer Attribution', 'crocal' ),
						'subtitle' => esc_html__( 'Enter the Tile Layer attribution', 'crocal' ),
						"default" => '&copy; <a href="//www.openstreetmap.org/copyright">OpenStreetMap</a>',
						'required' => array( 'map_api_mode', 'equals', 'openstreetmap' ),
					),
					array(
						'id'       => 'gmap_api_key',
						'type'     => 'text',
						'title'    => esc_html__( 'Google API Key', 'crocal' ),
						'subtitle' => $crocal_gmap_api_key_link,
						'default'  => '',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id'=>'gmap_custom_enabled',
						'type' => 'button_set',
						'title' => esc_html__( 'Enable Custom Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to enable custom style for your map.', 'crocal' ),
						'options' => array(
							'0' => esc_html__( 'No', 'crocal' ),
							'1' => esc_html__( 'Custom', 'crocal' ),
							'2' => esc_html__( 'Custom Code', 'crocal' ),
						),
						'default' => '0',
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),
					array(
						'id' => 'gmap_custom_code',
						'type' => 'textarea',
						'title' => esc_html__( 'Custom Code', 'crocal' ),
						'subtitle' => esc_html__( 'Copy and paste the JSON here.', 'crocal' ) . ' ' . $crocal_gmap_style_link,
						'default' => '',
						'rows' => '30',
						'required' => array( 'gmap_custom_enabled', 'equals', '2' ),
					),
					array(
						'id'       => 'gmap_water_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Water color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for water', 'crocal' ),
						'default'  => '#424242',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_landscape_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Landscape color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for landscape', 'crocal' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_poi_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Point of interest color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for point of interest', 'crocal' ),
						'default'  => '#232323',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_road_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Roads color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for roads', 'crocal' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_label_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Label', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to enable labels for your map.', 'crocal' ),
						'default' => 1,
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for labels', 'crocal' ),
						'default'  => '#777777',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_label_stroke_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Label Stroke color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a stroke color for labels', 'crocal' ),
						'default'  => '#1a1a1a',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_label_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'gmap_country_color',
						'type'     => 'color',
						'title'    => esc_html__( 'Country Stroke color', 'crocal' ),
						'subtitle' => esc_html__( 'Pick a color for country stroke.', 'crocal' ),
						'default'  => '#000000',
						'transparent' => false,
						'validate' => 'color',
						'required' => array( 'gmap_custom_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'gmap_zoom_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Zoom Control', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to enable zoom control for your map.', 'crocal' ),
						'default' => 0,
						'required' => array( 'gmap_custom_enabled', 'equals', array( '1', '2' ) ),
					),
					array(
						'id' => 'gmap_type_control',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Map Type Control', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to enable map type control for your map.', 'crocal' ),
						'default' => 0,
						'required' => array( 'map_api_mode', 'equals', 'google-maps' ),
					),						
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-error',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( '404 Page', 'crocal'),
				'id' => 'eut_redux_section_404',
				'subtitle' => esc_html__( 'You can find the settings for the 404 page here.', 'crocal' ),
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'page_404_header',
						'type' => 'switch',
						'title' => esc_html__( 'Show Header', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show header.', 'crocal' ),
						'default' => 0,
					),
					array(
						'id'   => 'info_style_page_404_header',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Page 404 Header Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Set the style for the default page header.', 'crocal' ),
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id' => 'page_404_header_style',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Header Style', 'crocal' ),
						'subtitle'=> esc_html__( 'Select your page header style.', 'crocal' ),
						'options' => $crocal_eutf_header_style,
						'default' => 'dark',
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id' => 'page_404_header_overlapping',
						'type' => 'select',
						'title' => esc_html__( 'Page 404 Header Overlapping', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want the Page Header overlaps the content. Combine this option with the Light or Dark Header. You can still override this when you edit each single page.', 'crocal' ),
						'options' => $crocal_eutf_enable_selection,
						'default' => 'yes',
						'required' => array( 'page_404_header', 'equals', 1 ),
					),
					array(
						'id'       => '404_content_background',
						'type'     => 'background',
						'title'    => esc_html__( 'Page 404 Content Background Image / Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select a background image or color for the 404 page.', 'crocal' ),
						'background-color' => true,
						'transparent' => false,
						'background-repeat' => true,
						'background-attachment' => true,
						'background-clip' => false,
						'background-size' => true,
						'default' => array (
							'background-color' => '#3e2ff4',
						),
					),
					array(
						'id' => 'page_404_content',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Page 404 Content', 'crocal' ),
						'subtitle' => esc_html__( 'Type the content of your 404 page, you can also use shortcodes.', 'crocal' ),
						'default' => '<div class="eut-headings-white eut-text-white"><h5>404 ERROR</h5><h1>Hey there!</h1><h3>Your lost treasure is not found here...</h3><p class="eut-leader-text">Sorry! The page you are looking for wasn\'t found!</p></div>',
					),
					array(
						'id' => 'page_404_search',
						'type' => 'checkbox',
						'title' => esc_html__( 'Show Search Box', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show a search box.', 'crocal' ),
						'default' => 0,
					),
					array(
						'id' => 'page_404_home_button',
						'type' => 'checkbox',
						'title' => esc_html__( 'Show Back to home Button', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show a back to home button.', 'crocal' ),
						'default' => 1,
					),
					array(
						'id' => 'page_404_footer',
						'type' => 'switch',
						'title' => esc_html__( 'Show Footer', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show footer.', 'crocal' ),
						'default' => 0,
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-wrench',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Coming Soon', 'crocal' ),
				'id' => 'eut_redux_section_coming_soon',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'=>'coming_soon_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Enable Coming Soon', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle Coming Soon Redirect on or off.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'coming_soon_template',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Template', 'crocal' ),
						'subtitle' => esc_html__( 'Select content only or use the defined page template.', 'crocal' ),
						'options' => array(
							'content' => esc_html__( 'Content Only', 'crocal' ),
							'template' => esc_html__( 'Use Page Template', 'crocal' ),
						),
						'default' => 'content',
						'validate' => 'not_empty',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'coming_soon_page',
						'type' => 'select',
						'title' => esc_html__( 'Coming Soon Page', 'crocal' ),
						'subtitle' => esc_html__( 'Select the page for your redirection.', 'crocal' ),
						'data' => 'page',
						'default' => '',
						'required' => array( 'coming_soon_enabled', 'equals', '1' ),
					),

				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-lock',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Privacy / Cookies', 'crocal' ),
				'desc' => esc_html__( 'The following shortcodes will allow your users to change certain behavior of your website regarding privacy.', 'crocal' ) . '<br>' .
					'<ul>' .
					'<li><strong>crocal_privacy_required</strong> - ' . esc_html__( 'displays a required content for your site e.g: Cloudlflare, CDN etc.', 'crocal' ) . '</li>' .
					'<li><strong>crocal_privacy_custom</strong> - ' . esc_html__( 'allows a user to enable/disable custom content', 'crocal' ) . '</li>' .
					'<li><strong>crocal_privacy_gtracking</strong> - ' . esc_html__( 'allows a user to enable/disable Google Analytics tracking code in the user\'s browser', 'crocal' ) . '</li>' .
					'<li><strong>crocal_privacy_gfonts</strong> - ' . esc_html__( 'allows a user to enable/disable the use of Google Fonts in the user\'s browser', 'crocal' ) . '</li>' .
					'<li><strong>crocal_privacy_gmaps</strong> - ' . esc_html__( 'allows a user to enable/disable the use of Google Maps in the user\'s browser', 'crocal' ) . '</li>' .
					'<li><strong>crocal_privacy_video_embeds</strong> - ' . esc_html__( 'allows a user to enable/disable video embeds in the user\'s browser', 'crocal' ) . '</li>' .
					'<li><strong>crocal_privacy_policy_page_link</strong> - ' . esc_html__( 'displays a link to the privacy policy page set from the WordPress admin panel', 'crocal' ) . '</li>' .
					'<li><strong>crocal_privacy_preferences_link</strong> - ' . esc_html__( 'displays a link to the privacy preferences as defined in the Privacy Consent Info Bar', 'crocal' ) . '</li>' .
					'</ul>' .
					esc_html__( 'You can use any of them in your privacy policy or in any text area that allows shortcodes.', 'crocal' ) . '<br><br>' .
					'<strong>[crocal_privacy_required value="required"]For performance and security reasons we use Cloudflare[/crocal_privacy_required]</strong><br>' .
					'<strong>[crocal_privacy_custom id="custom-id"]Click to enable/disable custom content.[/crocal_privacy_custom]</strong><br>' .

					'<strong>[crocal_privacy_gtracking]Click to enable/disable Google Analytics tracking code.[/crocal_privacy_gtracking]</strong><br>' .
					'<strong>[crocal_privacy_gfonts]Click to enable/disable Google Fonts.[/crocal_privacy_gfonts]</strong><br>' .
					'<strong>[crocal_privacy_gmaps]Click to enable/disable Google Maps.[/crocal_privacy_gmaps]</strong><br>' .
					'<strong>[crocal_privacy_video_embeds]Click to enable/disable video embeds.[/crocal_privacy_video_embeds]</strong><br>' .
					'<strong>[crocal_privacy_policy_page_link]</strong><br>' .
					'<strong>[crocal_privacy_preferences_link]</strong><br><br>' .
					esc_html__( 'Note: To change the default text add your text inside the shortcode tags [shortcode]Your text[/shortcode]', 'crocal' ),
				'id' => 'eut_redux_section_privacy_cookies',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'class' => 'eut-redux-desc-full',
				'fields' => array(
					array(
						'id'   => 'info_style_blocking_content',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Privacy Content Blocking Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Configure the privacy content blocking settings.', 'crocal' ) . '<br>' . esc_html__( 'Note: The usage of the Blocking content feature is not recommended if you have added caching plugins or page rules to cache static HTML content (aggressive cache). If you use this feature you might need to disable such type of caching.', 'crocal' ),
					),
					array(
						'id' => 'privacy_content_blocking_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Privacy Content Blocking', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to enable/disable privacy content blocking.', 'crocal' ) .'<br><br>' . esc_html__( 'Note: if you disable content blocking certain privacy shortcodes will be automatically disabled.', 'crocal' ),
						'default' => 1,
					),
					array(
						'id'      => 'privacy_initial_state',
						'type'    => 'checkbox',
						'title'   => esc_html__( 'Privacy Initial Blocking State', 'crocal' ),
						'subtitle'    => esc_html__( 'Check if you want to block the content when the page loads.', 'crocal' ),
						'options'  => array(
							'gtracking'     => 'Google Tracking',
							'gfonts' => 'Google Fonts',
							'gmaps' => 'Google Maps',
							'video-embeds'   => 'Embed Videos'
						),
						'default' => array(
							'gtracking'     => '0',
							'gfonts' => '0',
							'gmaps' => '0',
							'video-embeds'   => '0'
						),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
  					array(
						'id'=>'privacy_custom_fields',
						'type' => 'multi_text',
						'title' => esc_html__('Privacy Custom Blocking Content Ids', 'crocal'),
						'subtitle' => esc_html__('Enter the ids for your custom blocking content. e.g: custom-id', 'crocal'),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_fallback_content',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Privacy Fallback Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Configure the privacy fallback info box.', 'crocal' ),
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_fallback_content',
						'type' => 'textarea',
						'rows' => '2',
						'title' => esc_html__( 'Privacy Fallback Content', 'crocal' ),
						'subtitle' => esc_html__( 'Type the fallback text when the content is blocked.', 'crocal' ),
						'default' => 'This content is blocked. Please review your Privacy Preferences.',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'privacy_fallback_preferences_link_visibility',
						'type'     => 'checkbox',
						'title'    => esc_html__('Display Privacy Preferences link', 'crocal'),
						'subtitle' => esc_html__('Select if you want to display the Privacy Preferences link ( if defined in the privacy consent bar ).', 'crocal'),
						'default'  => '1',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'       => 'privacy_fallback_content_link_visibility',
						'type'     => 'checkbox',
						'title'    => esc_html__('Display redirect link of the blocked content', 'crocal'),
						'subtitle' => esc_html__('Select if you want to display a redirect link of the blocked content ( blocked content will open in a new tab e.g: YouTube website ).', 'crocal'),
						'default'  => '1',
						'required' => array( 'privacy_content_blocking_enabled', 'equals', '1' ),
					),
					array(
						'id'   => 'info_style_consent_bar',
						'type' => 'info',
						'class' => 'eut-redux-sub-info',
						'title' => esc_html__( 'Privacy Consent Info Bar Settings', 'crocal' ),
						'subtitle'=> esc_html__( 'Configure the consent info bar.', 'crocal' ),
					),
					array(
						'id' => 'privacy_consent_bar_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Privacy Consent Info Bar', 'crocal' ),
						'subtitle'=> esc_html__( 'Select if you want to show a privacy consent info bar.', 'crocal' ),
						'default' => 0,
					),
					array(
						'id' => 'privacy_consent_bar_position',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Privacy Consent Info Bar Position', 'crocal' ),
						'subtitle' => esc_html__( 'Select the position for Privacy Consent Info Bar', 'crocal' ),
						'options' => array(
							'center' => esc_html__( 'Center', 'crocal' ),
							'left' => esc_html__( 'Left', 'crocal' ),
							'right' => esc_html__( 'Right', 'crocal' ),
						),
						'default' => 'center',
						'validate' => 'not_empty',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id' => 'privacy_consent_bar_content',
						'type' => 'textarea',
						'rows' => '2',
						'title' => esc_html__( 'Privacy Info Bar Content', 'crocal' ),
						'subtitle' => esc_html__( 'Type the content of your consent info bar.', 'crocal' ),
						'default' => 'Our website uses cookies, mainly from 3rd party services. Define your Privacy Preferences and/or agree to our use of cookies.',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'privacy_agreement_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Agreement Button Label', 'crocal' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy agreement button. Leave empty to remove.', 'crocal' ),
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
						"default" => 'I Agree',
					),
					array(
						'id'=>'privacy_preferences_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Button Label', 'crocal' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy preferences button. Leave empty to remove.', 'crocal' ),
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
						"default" => 'Privacy Preferences',
					),
					array(
						'id' => 'privacy_preferences_button_link',
						'type' => 'select',
						'compiler' => true,
						'title' => esc_html__( 'Privacy Preferences Button Link Mode', 'crocal' ),
						'subtitle' => esc_html__( 'Select the preferences button link mode: modal, privacy policy page or custom url.', 'crocal' ),
						'options' => array(
							'modal' => esc_html__( 'Modal', 'crocal' ),
							'privacy_page' => esc_html__( 'Privacy Policy Page', 'crocal' ),
							'custom_url' => esc_html__( 'Custom URL', 'crocal' ),
						),
						'default' => 'modal',
						'validate' => 'not_empty',
						'required' => array( 'privacy_consent_bar_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'privacy_preferences_link_url',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Custom Link URL', 'crocal' ),
						'subtitle'=> esc_html__( 'Define a custom URL link for your privacy preferences button.', 'crocal' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '',
					),
					array(
						'id'=>'privacy_preferences_link_extra_class',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Preferences Custom Link Extra Class', 'crocal' ),
						'subtitle'=> esc_html__( 'Define a custom class for your privacy preferences button.', 'crocal' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '',
					),
					array(
						'id'=>'privacy_preferences_link_target',
						'type' => 'select',
						'title' => esc_html__( 'Privacy Preferences Custom Link Target', 'crocal' ),
						'subtitle'=> esc_html__( 'Define the target for your custom url, same or new page.', 'crocal' ),
						'options' => array(
							'_self' => esc_html__( 'Same Page', 'crocal' ),
							'_blank' => esc_html__( 'New page', 'crocal' ),
						),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'custom_url' ),
						),
						"default" => '_self',
					),
					array(
						'id' => 'privacy_consent_modal_content',
						'type' => 'editor',
						'args' => array ( 'wpautop' => false ),
						'title' => esc_html__( 'Privacy Modal Content', 'crocal' ),
						'subtitle' => esc_html__( 'Type the content of your modal consent dialog.', 'crocal' ),
						'default' => '<h5>Privacy Preferences</h5><p>When you visit our website, it may store information through your browser from specific services, usually in the form of cookies. Here you can change your Privacy preferences. It is worth noting that blocking some types of cookies may impact your experience on our website and the services we are able to offer.</p><div>[crocal_privacy_gtracking]Click to enable/disable Google Analytics tracking code.[/crocal_privacy_gtracking][crocal_privacy_gfonts]Click to enable/disable Google Fonts.[/crocal_privacy_gfonts][crocal_privacy_gmaps]Click to enable/disable Google Maps.[/crocal_privacy_gmaps][crocal_privacy_video_embeds]Click to enable/disable video embeds.[/crocal_privacy_video_embeds]</div>',
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'modal' ),
						),
					),
					array(
						'id'=>'privacy_refresh_button_label',
						'type' => 'text',
						'title' => esc_html__( 'Privacy Refresh Button Label', 'crocal' ),
						'subtitle'=> esc_html__( 'Define the label for your privacy refresh button. Leave empty to remove.', 'crocal' ),
						'required' => array(
							array( 'privacy_consent_bar_enabled', 'equals', '1' ),
							array( 'privacy_preferences_button_link', 'equals', 'modal' ),
						),
						"default" => 'Save Preferences',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-file-edit',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'CSS / JS Options', 'crocal' ),
				'id' => 'eut_redux_section_css_js_options',
				'submenu' => true,
				'subsection' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id' => 'css_code',
						'type' => 'ace_editor',
						'title' => esc_html__( 'CSS Code', 'crocal' ),
						'subtitle' => esc_html__( 'Paste your CSS code here.', 'crocal' ),
						'mode' => 'css',
						'theme' => 'monokai',
						'desc' => '',
						'default' => ''
					),
					array(
						'id' => 'custom_js',
						'type' => 'ace_editor',
						'mode' => 'javascript',
						'theme' => 'chrome',
						'title' => esc_html__( 'JS Code', 'crocal' ),
						'subtitle' => esc_html__( 'Add your custom JavaScript code here. Please do not include any script tags.', 'crocal' ),
						'desc' => '',
						'default' => ''
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Miscellaneous', 'crocal' ),
				'id' => 'eut_redux_section_miscellaneous',
				'submenu' => true,
				'customizer' => false,
				'fields' => array(
					array(
						'id'       => 'feature_section_post_types',
						'type'     => 'select',
						'multi'    => true,
						'title'    => esc_html__( 'Feature Section Post Types', 'crocal' ),
						'subtitle' => esc_html__( 'Select the post types you wish to enable the Feature Section.', 'crocal' ),
						'options' => $crocal_eutf_feature_section_post_types_selection,
						'default' => array( 'page', 'portfolio' ),
					),
					array(
						'id'=>'wp_gallery_popup',
						'type' => 'switch',
						'title' => esc_html__( 'Lightbox for WordPress Gallery', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle lightbox for native WordPress Gallery on or off.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
					array(
						'id'=>'wp_tagcloud',
						'type' => 'switch',
						'title' => esc_html__( 'Default WordPress Tag Cloud', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle default tag cloud on or off.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
					array(
						'id'=>'menu_header_integration',
						'type' => 'select',
						'title' => esc_html__( 'Main Menu Integration', 'crocal' ),
						'subtitle' => esc_html__( 'Select the main menu integration method. Selection available for custom menu integration.', 'crocal' ),
						'options' => $crocal_eutf_header_menu_selection,
						'default' => 'default',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'sidebar_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Sidebar Headings Tag', 'crocal' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Sidebar Titles.', 'crocal' ),
						'options' => $crocal_eutf_headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'footer_heading_tag',
						'type' => 'select',
						'title' => esc_html__( 'Footer Sidebar Headings Tag', 'crocal' ),
						'subtitle' => esc_html__( 'Select the headings tag for your Footer Sidebar Titles.', 'crocal' ),
						'options' => $crocal_eutf_headings_tag_selection,
						'default' => 'div',
						'validate' => 'not_empty',
					),
					array(
						'id' => 'spinner_image',
						'url' => true,
						'type' => 'media',
						'title' => esc_html__( 'Spinner Image', 'crocal' ),
						'subtitle' => esc_html__( 'Upload a custom image if you want to replace the default graphic spinner.', 'crocal' ),
					),
					array(
						'id' => 'scrolling_speed',
						'type' => 'select',
						'title' => esc_html__( 'Smooth Scrolling Speed', 'crocal' ),
						'subtitle'=> esc_html__( 'Select the scroll speed. Applied only when smooth scrolling is enabled.', 'crocal' ),
						'options' => array(
							'slow' => esc_html__( 'Slow', 'crocal' ),
							'normal' => esc_html__( 'Normal', 'crocal' ),
							'fast' => esc_html__( 'Fast', 'crocal' ),
						),
						'default' => 'normal',
					),
					array(
						'id'=>'device_animations',
						'type' => 'switch',
						'title' => esc_html__( 'Device Animations', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable/Disable animations for mobile devices.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
					array(
						'id'=>'device_hover_single_tap',
						'type' => 'switch',
						'title' => esc_html__( 'Device Single Tap', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable/Disable single tap for links/hovers on devices.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Page Builder Addons', 'crocal' ),
				'desc' => esc_html__( 'Enable/Disable default Page Builder functionality.', 'crocal' ),
				'id' => 'eut_redux_section_page_builder',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'vc_grid_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Grid Elements', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Grid elements on or off.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
					array(
						'id'=>'vc_charts_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Charts Elements', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder Charts elements on or off.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
					array(
						'id'=>'vc_woo_visibility',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder WooCommerce Elements', 'crocal' ),
						'subtitle'=> esc_html__( 'Toggle Page Builder WooCommerce elements on or off.', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
					array(
						'id'=>'vc_auto_updater',
						'type' => 'switch',
						'title' => esc_html__( 'Page Builder Auto Updater', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable/Disable Page Builder Auto Updater ( Activation Required ).', 'crocal' ),
						"default" => '0',
						'on' => esc_html__('On', 'crocal' ),
						'off' => esc_html__('Off', 'crocal' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Button Settings', 'crocal' ),
				'desc' => esc_html__( 'Set the style for the buttons.', 'crocal' ),
				'id' => 'eut_redux_section_buttons',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'button_type',
						'type' => 'select',
						'title' => esc_html__( 'Button Type', 'crocal' ),
						'subtitle' => esc_html__( 'Select the type of your Buttons.', 'crocal' ),
						'options' => $crocal_eutf_button_type_selection,
						'default' => 'simple',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_shape',
						'type' => 'select',
						'title' => esc_html__( 'Button Shape', 'crocal' ),
						'subtitle' => esc_html__( 'Select the shape of your Buttons.', 'crocal' ),
						'options' => $crocal_eutf_button_shape_selection,
						'default' => 'square',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the color of your Buttons.', 'crocal' ),
						'options' => $crocal_eutf_button_color_selection,
						'default' => 'black',
						'validate' => 'not_empty',
					),
					array(
						'id'=>'button_hover_color',
						'type' => 'select',
						'title' => esc_html__( 'Button Hover Color', 'crocal' ),
						'subtitle' => esc_html__( 'Select the hover color of your Buttons.', 'crocal' ),
						'options' => $crocal_eutf_button_color_selection,
						'default' => 'primary-1',
						'validate' => 'not_empty',
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Back To Top', 'crocal' ),
				'desc' => esc_html__( 'Set the style for the back to top button.', 'crocal' ),
				'id' => 'eut_redux_section_back_top_top',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'back_to_top_enabled',
						'type' => 'switch',
						'title' => esc_html__( 'Back to Top', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable the Back to Top button.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'back_to_top_shape',
						'type' => 'select',
						'title' => esc_html__( 'Back to Top Icon Shape', 'crocal' ),
						'subtitle' => esc_html__( 'Select the shape of Back to Top button.', 'crocal' ),
						'options' => array(
							'none' => esc_html__( 'No Shape', 'crocal' ),
							'square' => esc_html__( 'Square', 'crocal' ),
							'round' => esc_html__( 'Round', 'crocal' ),
							'circle' => esc_html__( 'Circle', 'crocal' ),
						),
						'default' => 'circle',
						'validate' => 'not_empty',
						'required' => array( 'back_to_top_enabled', 'equals', '1' ),
					),
					array(
						'id'=>'back_to_top_speed',
						'type' => 'select',
						'title' => esc_html__( 'Back to Top Speed', 'crocal' ),
						'subtitle' => esc_html__( 'Select the speed for Back to Top animation.', 'crocal' ),
						'options' => array(
							'height-based' => esc_html__( 'Height Based', 'crocal' ),
							'1000' => esc_html__( 'Normal', 'crocal' ),
							'600' => esc_html__( 'Fast', 'crocal' ),
							'300' => esc_html__( 'Faster', 'crocal' ),
						),
						'default' => 'height-based',
						'validate' => 'not_empty',
						'required' => array( 'back_to_top_enabled', 'equals', '1' ),
					),
				)
			);

			$this->sections[] = array(
				'icon' => 'el-icon-cog',
				'icon_class' => 'el-icon-large',
				'title' => esc_html__( 'Meta Tags', 'crocal' ),
				'desc' => esc_html__( 'Configure your site meta tags.', 'crocal' ),
				'id' => 'eut_redux_section_meta_tags',
				'submenu' => true,
				'customizer' => false,
				'subsection' => true,
				'fields' => array(
					array(
						'id'=>'meta_viewport_responsive',
						'type' => 'switch',
						'title' => esc_html__( 'Responsive Viewport Meta', 'crocal' ),
						'subtitle'=> esc_html__( 'Enable or Disable Responsive Viewport.', 'crocal' ),
						"default" => '1',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'meta_opengraph',
						'type' => 'switch',
						'title' => esc_html__( 'Open Graph Meta', 'crocal' ),
						'subtitle'=> esc_html__( 'Generate open graph meta tags for social sharing ( e.g: Facebook, Google+, LinkedIn etc )', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
					array(
						'id'=>'meta_twitter',
						'type' => 'switch',
						'title' => esc_html__( 'Twitter Card Meta', 'crocal' ),
						'subtitle'=> esc_html__( 'Generate meta tags for Twitter', 'crocal' ),
						"default" => '0',
						'on' => esc_html__( 'On', 'crocal' ),
						'off' => esc_html__( 'Off', 'crocal' ),
					),
				)
			);

			//Show Sections available only in customizer
			if ( ( defined( 'CROCAL_EUTF_THEME_REDUX_CUSTOM_PANEL' ) &&  true === CROCAL_EUTF_THEME_REDUX_CUSTOM_PANEL ) || $this->crocal_eutf_redux_customizer_visibility() ) {
				foreach ( $this->sections as $k => $section ) {
					if ( isset( $section['eut_colors'] ) && isset( $section['panel'] ) ) {
						unset($this->sections[$k]['panel']);
					}
				}
			}

		}


		public function setArguments() {

			$theme = wp_get_theme();
			$theme_version = $theme->get('Version');
			if( is_child_theme() ) {
				$parent_theme = wp_get_theme( get_template() );
				$theme_version .= ' ( ' . $parent_theme->get('Name') .': ' . $parent_theme->get('Version') . ' )';
			}

			$this->args = array(
				// TYPICAL -> Change these values as you need/desire
				'opt_name' => 'crocal_eutf_options', // This is where your data is stored in the database and also becomes your global variable name.
				'display_name' => ' ', // Name that appears at the top of your panel
				'display_version' => $theme_version, // Version that appears at the top of your panel
				'menu_type' => 'submenu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
				'allow_sub_menu' => false, // Show the sections below the admin menu item or not
				'menu_title' => esc_html__( 'Theme Options', 'crocal' ),
				'page_title' => esc_html__( 'Theme Options', 'crocal' ),
				'google_api_key' => 'AIzaSyBBgve_JGMTPX8CWMxeoG1KrfmUF6WN4NE', // Must be defined to add google fonts to the typography module
				'admin_bar' => false, // Show the panel pages on the admin bar
				'global_variable' => 'crocal_eutf_options', // Set a different name for your global variable other than the opt_name
				'dev_mode' => false, // Show the time the page took to load, etc
				'customizer' => true, // Enable basic customizer support
				'ajax_save' => true,
				'ajax_max_input' => true,
				'templates_path' => get_template_directory() . '/includes/admin/templates/panel', //Redux Template files

				// OPTIONAL -> Give you extra features
				'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
				'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
				'page_permissions' => 'manage_options', // Permissions needed to access the options panel.
				'menu_icon' => get_template_directory_uri() .'/includes/images/adminmenu/theme.png', // Specify a custom URL to an icon
				'last_tab' => '', // Force your panel to always open to a specific tab (by id)
				'page_icon' => 'icon-themes', // Icon displayed in the admin panel next to your menu_title
				'page_slug' => 'crocal_eutf_options', // Page slug used to denote the panel
				'save_defaults' => true, // On load save the defaults to DB before user clicks save or not
				'default_show' => false, // If true, shows the default value next to each field that is not the default value.
				'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *

				// CAREFUL -> These options are for advanced use only
				'output_location' => array( 'frontend', 'admin' ),
				'use_cdn' => false,
				'transient_time' => 60 * MINUTE_IN_SECONDS,
				'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
				'output_tag' => true, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head

				// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
				'database' => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
				'show_import_export' => true,
				'disable_tracking' => true,
				'allow_tracking' => false,
				'help_tabs' => array(),
				'help_sidebar' => '',
			);

			// Panel Intro text -> before the form
			$this->args['intro_text'] ='';

			// Add content after the form.
			$this->args['footer_text'] = '';
			$this->args['footer_credit'] = ' ';

		}

	}

	global $crocal_eutf_redux_framework;
	$crocal_eutf_redux_framework = new Crocal_Eutf_Redux_Framework_config();
}

//Omit closing PHP tag to avoid accidental whitespace output errors.
