<?php

/*
*	Global Parameter and functions
*
* 	@version	1.0
* 	@author		Euthemians Team
* 	@URI		http://euthemians.com
*/

$crocal_eutf_social_list = array(
	'twitter' => 'Twitter',
	'facebook' => 'Facebook',
	'google-plus' => 'Google Plus',
	'instagram' => 'Instagram',
	'linkedin' => 'LinkedIn',
	'tumblr' => 'Tumblr',
	'pinterest' => 'Pinterest',
	'github' => 'Github',
	'dribbble' => 'Dribbble',
	'reddit' => 'reddit',
	'flickr' => 'Flickr',
	'skype' => 'Skype',
	'youtube' => 'YouTube',
	'vimeo' => 'Vimeo',
	'soundcloud' => 'SoundCloud',
	'wechat' => 'WeChat',
	'weibo' => 'Weibo',
	'renren' => 'Renren',
	'qq' => 'QQ',
	'xing' => 'XING',
	'rss' => 'RSS',
	'vk' => 'VK',
	'behance' => 'Behance',
	'foursquare' => 'Foursquare',
	'steam' => 'Steam',
	'twitch' => 'Twitch',
	'houzz' => 'Houzz',
	'yelp' => 'Yelp',
	'snapchat' => 'Snapchat',
	'medium' => 'Medium',
	'tripadvisor' => 'TripAdvisor',
	'spotify' => 'Spotify',
	'whatsapp' => 'WhatsApp',
);

$crocal_eutf_social_list_extended = array (
	'twitter' => array(
		'title' => 'Twitter',
		'url' => 'twitter_url',
		'id' => 'twitter',
		'class' => 'fab fa-twitter',
	),
	'facebook' => array(
		'title' => 'Facebook',
		'url' => 'facebook_url',
		'id' => 'facebook',
		'class' => 'fab fa-facebook-f',
	),
	'google-plus' => array(
		'title' => 'Google+',
		'url' => 'googleplus_url',
		'id' => 'google-plus',
		'class' => 'fab fa-google-plus-g',
	),
	'instagram' => array(
		'title' => 'Instagram',
		'url' => 'instagram_url',
		'id' => 'instagram',
		'class' => 'fab fa-instagram',
	),
	'linkedin' => array(
		'title' => 'LinkedIn',
		'url' => 'linkedin_url',
		'id' => 'linkedin',
		'class' => 'fab fa-linkedin-in',
	),
	'tumblr' => array(
		'title' => 'Tumblr',
		'url' => 'tumblr_url',
		'id' => 'tumblr',
		'class' => 'fab fa-tumblr',
	),
	'pinterest' => array(
		'title' => 'Pinterest',
		'url' => 'pinterest_url',
		'id' => 'pinterest',
		'class' => 'fab fa-pinterest',
	),
	'github' => array(
		'title' => 'GitHub',
		'url' => 'github_url',
		'id' => 'github',
		'class' => 'fab fa-github',
	),
	'dribbble' => array(
		'title' => 'Dribbble',
		'url' => 'dribbble_url',
		'id' => 'dribbble',
		'class' => 'fab fa-dribbble',
	),
	'reddit' => array(
		'title' => 'reddit',
		'url' => 'reddit_url',
		'id' => 'reddit',
		'class' => 'fab fa-reddit',
	),
	'flickr' => array(
		'title' => 'Flickr',
		'url' => 'flickr_url',
		'id' => 'flickr',
		'class' => 'fab fa-flickr',
	),
	'skype' => array(
		'title' => 'Skype',
		'url' => 'skype_url',
		'id' => 'skype',
		'class' => 'fab fa-skype',
	),
	'youtube' => array(
		'title' => 'YouTube',
		'url' => 'youtube_url',
		'id' => 'youtube',
		'class' => 'fab fa-youtube',
	),
	'vimeo' => array(
		'title' => 'Vimeo',
		'url' => 'vimeo_url',
		'id' => 'vimeo',
		'class' => 'fab fa-vimeo',
	),
	'soundcloud' => array(
		'title' => 'SoundCloud',
		'url' => 'soundcloud_url',
		'id' => 'soundcloud',
		'class' => 'fab fa-soundcloud',
	),
	'wechat' => array(
		'title' => 'WeChat',
		'url' => 'wechat_url',
		'id' => 'wechat',
		'class' => 'fab fa-weixin',
	),
	'weibo' => array(
		'title' => 'Weibo',
		'url' => 'weibo_url',
		'id' => 'weibo',
		'class' => 'fab fa-weibo',
	),
	'renren' => array(
		'title' => 'Renren',
		'url' => 'renren_url',
		'id' => 'renren',
		'class' => 'fab fa-renren',
	),
	'qq' => array(
		'title' => 'QQ',
		'url' => 'qq_url',
		'id' => 'qq',
		'class' => 'fab fa-qq',
	),
	'xing' => array(
		'title' => 'XING',
		'url' => 'xing_url',
		'id' => 'xing',
		'class' => 'fab fa-xing',
	),
	'rss' => array(
		'title' => 'RSS',
		'url' => 'rss_url',
		'id' => 'rss',
		'class' => 'fas fa-rss',
	),
	'vk' => array(
		'title' => 'VK',
		'url' => 'vk_url',
		'id' => 'vk',
		'class' => 'fab fa-vk',
	),
	'behance' => array(
		'title' => 'Behance',
		'url' => 'behance_url',
		'id' => 'behance',
		'class' => 'fab fa-behance',
	),
	'foursquare' => array(
		'title' => 'Foursquare',
		'url' => 'foursquare_url',
		'id' => 'foursquare',
		'class' => 'fab fa-foursquare',
	),
	'steam' => array(
		'title' => 'Steam',
		'url' => 'steam_url',
		'id' => 'steam',
		'class' => 'fab fa-steam',
	),
	'twitch' => array(
		'title' => 'Twitch',
		'url' => 'twitch_url',
		'id' => 'twitch',
		'class' => 'fab fa-twitch',
	),
	'houzz' => array(
		'title' => 'Houzz',
		'url' => 'houzz_url',
		'id' => 'houzz',
		'class' => 'fab fa-houzz',
	),
	'yelp' => array(
		'title' => 'Yelp',
		'url' => 'yelp_url',
		'id' => 'yelp',
		'class' => 'fab fa-yelp',
	),
	'snapchat' => array(
		'title' => 'Snapchat',
		'url' => 'snapchat_url',
		'id' => 'snapchat',
		'class' => 'fab fa-snapchat',
	),
	'medium' => array(
		'title' => 'Medium',
		'url' => 'medium_url',
		'id' => 'medium',
		'class' => 'fab fa-medium',
	),
	'tripadvisor' => array(
		'title' => 'TripAdvisor',
		'url' => 'tripadvisor_url',
		'id' => 'tripadvisor',
		'class' => 'fab fa-tripadvisor',
	),
	'spotify' => array(
		'title' => 'Spotify',
		'url' => 'spotify_url',
		'id' => 'spotify',
		'class' => 'fab fa-spotify',
	),	
	'whatsapp' => array(
		'title' => 'WhatsApp',
		'url' => 'whatsapp_url',
		'id' => 'whatsapp',
		'class' => 'fab fa-whatsapp',
	),	
);

$crocal_eutf_post_color_selection = array(
	'primary-1' => esc_html__( 'Primary 1', 'crocal' ),
	'primary-2' => esc_html__( 'Primary 2', 'crocal' ),
	'primary-3' => esc_html__( 'Primary 3', 'crocal' ),
	'primary-4' => esc_html__( 'Primary 4', 'crocal' ),
	'primary-5' => esc_html__( 'Primary 5', 'crocal' ),
	'primary-6' => esc_html__( 'Primary 6', 'crocal' ),
	'green' => esc_html__( 'Green', 'crocal' ),
	'orange' => esc_html__( 'Orange', 'crocal' ),
	'red' => esc_html__( 'Red', 'crocal' ),
	'blue' => esc_html__( 'Blue', 'crocal' ),
	'aqua' => esc_html__( 'Aqua', 'crocal' ),
	'purple' => esc_html__( 'Purple', 'crocal' ),
	'black' => esc_html__( 'Black', 'crocal' ),
	'grey' => esc_html__( 'Grey', 'crocal' ),
);

$crocal_eutf_button_color_selection = array(
	'primary-1' => esc_html__( 'Primary 1', 'crocal' ),
	'primary-2' => esc_html__( 'Primary 2', 'crocal' ),
	'primary-3' => esc_html__( 'Primary 3', 'crocal' ),
	'primary-4' => esc_html__( 'Primary 4', 'crocal' ),
	'primary-5' => esc_html__( 'Primary 5', 'crocal' ),
	'primary-6' => esc_html__( 'Primary 6', 'crocal' ),
	'green' => esc_html__( 'Green', 'crocal' ),
	'orange' => esc_html__( 'Orange', 'crocal' ),
	'red' => esc_html__( 'Red', 'crocal' ),
	'blue' => esc_html__( 'Blue', 'crocal' ),
	'aqua' => esc_html__( 'Aqua', 'crocal' ),
	'purple' => esc_html__( 'Purple', 'crocal' ),
	'black' => esc_html__( 'Black', 'crocal' ),
	'grey' => esc_html__( 'Grey', 'crocal' ),
	'white' => esc_html__( 'White', 'crocal' ),
);

$crocal_eutf_button_size_selection = array(
	'extrasmall' => esc_html__( 'Extra Small', 'crocal' ),
	'small' => esc_html__( 'Small', 'crocal' ),
	'medium' => esc_html__( 'Medium', 'crocal' ),
	'large' => esc_html__( 'Large', 'crocal' ),
	'extralarge' => esc_html__( 'Extra Large', 'crocal' ),
);

$crocal_eutf_button_shape_selection = array(
	'square' => esc_html__( 'Square', 'crocal' ),
	'round' => esc_html__( 'Round', 'crocal' ),
	'extra-round' => esc_html__( 'Extra Round', 'crocal' ),
);

$crocal_eutf_button_type_selection = array(
	'simple' => esc_html__( 'Simple', 'crocal' ),
	'outline' => esc_html__( 'Outline', 'crocal' ),
);

$crocal_eutf_post_bg_opacity_selection = array(
	'none' => '0%',
	'10' => '10%',
	'20' => '20%',
	'30' => '30%',
	'40' => '40%',
	'50' => '50%',
	'60' => '60%',
	'70' => '70%',
	'80' => '80%',
	'90' => '90%',
	'100' => '100%',
);

$crocal_eutf_area_height = array(
	'small' => esc_html__( 'Small Height', 'crocal' ),
	'medium' => esc_html__( 'Medium Height', 'crocal' ),
	'large' => esc_html__( 'Large Height', 'crocal' ),
	'10' => '10%',
	'15' => '15%',
	'20' => '20%',
	'25' => '25%',
	'30' => '30%',
	'35' => '35%',
	'40' => '40%',
	'45' => '45%',
	'50' => '50%',
	'55' => '55%',
	'60' => '60%',
	'65' => '65%',
	'70' => '70%',
	'75' => '75%',
	'80' => '80%',
	'85' => '85%',
	'90' => '90%',
);

$crocal_eutf_awsome_fonts_list = array( "500px", "address-book", "address-book-o", "address-card", "address-card-o", "adjust", "adn", "align-center", "align-justify", "align-left", "align-right", "amazon", "ambulance", "american-sign-language-interpreting", "anchor", "android", "angellist", "angle-double-down", "angle-double-left", "angle-double-right", "angle-double-up", "angle-down", "angle-left", "angle-right", "angle-up", "apple", "archive", "area-chart", "arrow-circle-down", "arrow-circle-left", "arrow-circle-o-down", "arrow-circle-o-left", "arrow-circle-o-right", "arrow-circle-o-up", "arrow-circle-right", "arrow-circle-up", "arrow-down", "arrow-left", "arrow-right", "arrow-up", "arrows", "arrows-alt", "arrows-h", "arrows-v", "asl-interpreting", "assistive-listening-systems", "asterisk", "at", "audio-description", "automobile", "backward", "balance-scale", "ban", "bandcamp", "bank", "bar-chart", "bar-chart-o", "barcode", "bars", "bath", "bathtub", "battery", "battery-0", "battery-1", "battery-2", "battery-3", "battery-4", "battery-empty", "battery-full", "battery-half", "battery-quarter", "battery-three-quarters", "bed", "beer", "behance", "behance-square", "bell", "bell-o", "bell-slash", "bell-slash-o", "bicycle", "binoculars", "birthday-cake", "bitbucket", "bitbucket-square", "bitcoin", "black-tie", "blind", "bluetooth", "bluetooth-b", "bold", "bolt", "bomb", "book", "bookmark", "bookmark-o", "braille", "briefcase", "btc", "bug", "building", "building-o", "bullhorn", "bullseye", "bus", "buysellads", "cab", "calculator", "calendar", "calendar-check-o", "calendar-minus-o", "calendar-o", "calendar-plus-o", "calendar-times-o", "camera", "camera-retro", "car", "caret-down", "caret-left", "caret-right", "caret-square-o-down", "caret-square-o-left", "caret-square-o-right", "caret-square-o-up", "caret-up", "cart-arrow-down", "cart-plus", "cc", "cc-amex", "cc-diners-club", "cc-discover", "cc-jcb", "cc-mastercard", "cc-paypal", "cc-stripe", "cc-visa", "certificate", "chain", "chain-broken", "check", "check-circle", "check-circle-o", "check-square", "check-square-o", "chevron-circle-down", "chevron-circle-left", "chevron-circle-right", "chevron-circle-up", "chevron-down", "chevron-left", "chevron-right", "chevron-up", "child", "chrome", "circle", "circle-o", "circle-o-notch", "circle-thin", "clipboard", "clock-o", "clone", "close", "cloud", "cloud-download", "cloud-upload", "cny", "code", "code-fork", "codepen", "codiepie", "coffee", "cog", "cogs", "columns", "comment", "comment-o", "commenting", "commenting-o", "comments", "comments-o", "compass", "compress", "connectdevelop", "contao", "copy", "copyright", "creative-commons", "credit-card", "credit-card-alt", "crop", "crosshairs", "css3", "cube", "cubes", "cut", "cutlery", "dashboard", "dashcube", "database", "deaf", "deafness", "dedent", "delicious", "desktop", "deviantart", "diamond", "digg", "dollar", "dot-circle-o", "download", "dribbble", "drivers-license", "drivers-license-o", "dropbox", "drupal", "edge", "edit", "eercast", "eject", "ellipsis-h", "ellipsis-v", "empire", "envelope", "envelope-o", "envelope-open", "envelope-open-o", "envelope-square", "envira", "eraser", "etsy", "eur", "euro", "exchange", "exclamation", "exclamation-circle", "exclamation-triangle", "expand", "expeditedssl", "external-link", "external-link-square", "eye", "eye-slash", "eyedropper", "fa", "facebook", "facebook-f", "facebook-official", "facebook-square", "fast-backward", "fast-forward", "fax", "feed", "female", "fighter-jet", "file", "file-archive-o", "file-audio-o", "file-code-o", "file-excel-o", "file-image-o", "file-movie-o", "file-o", "file-pdf-o", "file-photo-o", "file-picture-o", "file-powerpoint-o", "file-sound-o", "file-text", "file-text-o", "file-video-o", "file-word-o", "file-zip-o", "files-o", "film", "filter", "fire", "fire-extinguisher", "firefox", "first-order", "flag", "flag-checkered", "flag-o", "flash", "flask", "flickr", "floppy-o", "folder", "folder-o", "folder-open", "folder-open-o", "font", "font-awesome", "fonticons", "fort-awesome", "forumbee", "forward", "foursquare", "free-code-camp", "frown-o", "futbol-o", "gamepad", "gavel", "gbp", "ge", "gear", "gears", "genderless", "get-pocket", "gg", "gg-circle", "gift", "git", "git-square", "github", "github-alt", "github-square", "gitlab", "gittip", "glass", "glide", "glide-g", "globe", "google", "google-plus", "google-plus-circle", "google-plus-official", "google-plus-square", "google-wallet", "graduation-cap", "gratipay", "grav", "group", "h-square", "hacker-news", "hand-grab-o", "hand-lizard-o", "hand-o-down", "hand-o-left", "hand-o-right", "hand-o-up", "hand-paper-o", "hand-peace-o", "hand-pointer-o", "hand-rock-o", "hand-scissors-o", "hand-spock-o", "hand-stop-o", "handshake-o", "hard-of-hearing", "hashtag", "hdd-o", "header", "headphones", "heart", "heart-o", "heartbeat", "history", "home", "hospital-o", "hotel", "hourglass", "hourglass-1", "hourglass-2", "hourglass-3", "hourglass-end", "hourglass-half", "hourglass-o", "hourglass-start", "houzz", "html5", "i-cursor", "id-badge", "id-card", "id-card-o", "ils", "image", "imdb", "inbox", "indent", "industry", "info", "info-circle", "inr", "instagram", "institution", "internet-explorer", "intersex", "ioxhost", "italic", "joomla", "jpy", "jsfiddle", "key", "keyboard-o", "krw", "language", "laptop", "lastfm", "lastfm-square", "leaf", "leanpub", "legal", "lemon-o", "level-down", "level-up", "life-bouy", "life-buoy", "life-ring", "life-saver", "lightbulb-o", "line-chart", "link", "linkedin", "linkedin-square", "linode", "linux", "list", "list-alt", "list-ol", "list-ul", "location-arrow", "lock", "long-arrow-down", "long-arrow-left", "long-arrow-right", "long-arrow-up", "low-vision", "magic", "magnet", "mail-forward", "mail-reply", "mail-reply-all", "male", "map", "map-marker", "map-o", "map-pin", "map-signs", "mars", "mars-double", "mars-stroke", "mars-stroke-h", "mars-stroke-v", "maxcdn", "meanpath", "medium", "medkit", "meetup", "meh-o", "mercury", "microchip", "microphone", "microphone-slash", "minus", "minus-circle", "minus-square", "minus-square-o", "mixcloud", "mobile", "mobile-phone", "modx", "money", "moon-o", "mortar-board", "motorcycle", "mouse-pointer", "music", "navicon", "neuter", "newspaper-o", "object-group", "object-ungroup", "odnoklassniki", "odnoklassniki-square", "opencart", "openid", "opera", "optin-monster", "outdent", "pagelines", "paint-brush", "paper-plane", "paper-plane-o", "paperclip", "paragraph", "paste", "pause", "pause-circle", "pause-circle-o", "paw", "paypal", "pencil", "pencil-square", "pencil-square-o", "percent", "phone", "phone-square", "photo", "picture-o", "pie-chart", "pied-piper", "pied-piper-alt", "pied-piper-pp", "pinterest", "pinterest-p", "pinterest-square", "plane", "play", "play-circle", "play-circle-o", "plug", "plus", "plus-circle", "plus-square", "plus-square-o", "podcast", "power-off", "print", "product-hunt", "puzzle-piece", "qq", "qrcode", "question", "question-circle", "question-circle-o", "quora", "quote-left", "quote-right", "ra", "random", "ravelry", "rebel", "recycle", "reddit", "reddit-alien", "reddit-square", "refresh", "registered", "remove", "renren", "reorder", "repeat", "reply", "reply-all", "resistance", "retweet", "rmb", "road", "rocket", "rotate-left", "rotate-right", "rouble", "rss", "rss-square", "rub", "ruble", "rupee", "s15", "safari", "save", "scissors", "scribd", "search", "search-minus", "search-plus", "sellsy", "send", "send-o", "server", "share", "share-alt", "share-alt-square", "share-square", "share-square-o", "shekel", "sheqel", "shield", "ship", "shirtsinbulk", "shopping-bag", "shopping-basket", "shopping-cart", "shower", "sign-in", "sign-language", "sign-out", "signal", "signing", "simplybuilt", "sitemap", "skyatlas", "skype", "slack", "sliders", "slideshare", "smile-o", "snapchat", "snapchat-ghost", "snapchat-square", "snowflake-o", "soccer-ball-o", "sort", "sort-alpha-asc", "sort-alpha-desc", "sort-amount-asc", "sort-amount-desc", "sort-asc", "sort-desc", "sort-down", "sort-numeric-asc", "sort-numeric-desc", "sort-up", "soundcloud", "space-shuttle", "spinner", "spoon", "spotify", "square", "square-o", "stack-exchange", "stack-overflow", "star", "star-half", "star-half-empty", "star-half-full", "star-half-o", "star-o", "steam", "steam-square", "step-backward", "step-forward", "stethoscope", "sticky-note", "sticky-note-o", "stop", "stop-circle", "stop-circle-o", "street-view", "strikethrough", "stumbleupon", "stumbleupon-circle", "subscript", "subway", "suitcase", "sun-o", "superpowers", "superscript", "support", "table", "tablet", "tachometer", "tag", "tags", "tasks", "taxi", "telegram", "television", "tencent-weibo", "terminal", "text-height", "text-width", "th", "th-large", "th-list", "themeisle", "thermometer", "thermometer-0", "thermometer-1", "thermometer-2", "thermometer-3", "thermometer-4", "thermometer-empty", "thermometer-full", "thermometer-half", "thermometer-quarter", "thermometer-three-quarters", "thumb-tack", "thumbs-down", "thumbs-o-down", "thumbs-o-up", "thumbs-up", "ticket", "times", "times-circle", "times-circle-o", "times-rectangle", "times-rectangle-o", "tint", "toggle-down", "toggle-left", "toggle-off", "toggle-on", "toggle-right", "toggle-up", "trademark", "train", "transgender", "transgender-alt", "trash", "trash-o", "tree", "trello", "tripadvisor", "trophy", "truck", "try", "tty", "tumblr", "tumblr-square", "turkish-lira", "tv", "twitch", "twitter", "twitter-square", "umbrella", "underline", "undo", "universal-access", "university", "unlink", "unlock", "unlock-alt", "unsorted", "upload", "usb", "usd", "user", "user-circle", "user-circle-o", "user-md", "user-o", "user-plus", "user-secret", "user-times", "users", "vcard", "vcard-o", "venus", "venus-double", "venus-mars", "viacoin", "viadeo", "viadeo-square", "video-camera", "vimeo", "vimeo-square", "vine", "vk", "volume-control-phone", "volume-down", "volume-off", "volume-up", "warning", "wechat", "weibo", "weixin", "whatsapp", "wheelchair", "wheelchair-alt", "wifi", "wikipedia-w", "window-close", "window-close-o", "window-maximize", "window-minimize", "window-restore", "windows", "won", "wordpress", "wpbeginner", "wpexplorer", "wpforms", "wrench", "xing", "xing-square", "y-combinator", "y-combinator-square", "yahoo", "yc", "yc-square", "yelp", "yen", "yoast", "youtube", "youtube-play", "youtube-square" );

if ( !function_exists('crocal_eutf_build_separator') ) {
	function crocal_eutf_build_separator( $separator = '' , $color = '#ffffff' ) {

		switch( $separator ) {
			case 'triangle-separator':
				$separator_svg = '<svg class="eut-separator eut-svg-triangle" xmlns="http://www.w3.org/2000/svg" version="1.1" fill="' . esc_attr( $color ) . '" width="100%" height="100%" viewBox="0 0 90 50"><polygon points="0,50 45,0 90,50 "/></svg>';
				break;
			case 'large-triangle-separator':
				$separator_svg = '<svg class="eut-separator eut-svg-large-triangle" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><polygon fill="' . esc_attr( $color ) . '" points="960,45 0,0 0,90 1920,90 1920,0 "/></svg>';
				break;
			case 'tilt-left-separator':
				$separator_svg = '<svg class="eut-separator eut-tilt-left-separator" xmlns="http://www.w3.org/2000/svg" version="1.1" fill="' . esc_attr( $color ) . '" width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><polygon class="fil0" points="1920,90 0,90 1920,0 "/></svg>';
				break;
			case 'tilt-right-separator':
				$separator_svg = '<svg class="eut-separator eut-tilt-right-separator" xmlns="http://www.w3.org/2000/svg" version="1.1" fill="' . esc_attr( $color ) . '" width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><polygon class="fil0" points="0,90 1920,90 0,0 "/></svg>';
				break;
			case 'curve-separator':
				$separator_svg = '<svg class="eut-separator eut-curve-separator" xmlns="http://www.w3.org/2000/svg" version="1.1"  width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" d="M0,90C0,40.294,429.807,0,960,0s960,40.294,960,90H0z"/></svg>';
				break;
			case 'curve-left-separator':
				$separator_svg = '<svg class="eut-separator eut-curve-left-separator" xmlns="http://www.w3.org/2000/svg" version="1.1"  width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" d="M0,0c703,0,1799.426,155.567,1920,0v90H0V0z"/></svg>';
				break;
			case 'curve-right-separator':
				$separator_svg = '<svg class="eut-separator eut-curve-right-separator" xmlns="http://www.w3.org/2000/svg" version="1.1"  width="100%" height="100%" viewBox="0 0 1920 90" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" d="M1920,0C1217,0,120.574,155.567,0,0v90h1920V0z"/></svg>';
				break;
			case 'round-split-separator':
				$separator_svg = '<svg class="eut-separator eut-round-split-separator" xmlns="http://www.w3.org/2000/svg" version="1.1"  width="100%" height="100%" viewBox="0 0 90 45" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" d="M90,45L90,45C65.148,44.999,45,24.854,45,0l0,0c0,24.854-20.146,44.999-45,44.999V45H90z"/></svg>';
				break;
			case 'wave-left-separator':
				$separator_svg = '<svg class="eut-separator eut-wave-left-separator" width="100%" height="100%" viewBox="0 0 1440 435" preserveAspectRatio="none"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><path d="M1440,418.895124 C1440,418.895124 1440,424.263416 1440,435 L0,435 C4.54747351e-13,219.180056 4.54747351e-13,95.5797844 2.27373675e-13,64.1991849 C-2.27373675e-13,17.1282856 187,-68.1660779 300.539063,97.8434653 C414.078125,263.853008 630.21875,564.807139 918.53125,342.462329 C1206.84375,120.117519 1440,353.224824 1440,418.895124 Z" fill="' . esc_attr( $color ) . '" fill-rule="nonzero" opacity="0.3"></path><path d="M1440,421.483352 C1440,421.483352 1440,425.988902 1440,435 L0,435 C4.54747351e-13,253.864665 4.54747351e-13,150.1283 2.27373675e-13,123.790903 C-2.27373675e-13,84.2848086 187,12.6981757 300.539063,152.028182 C414.078125,291.358189 630.21875,543.945722 918.53125,357.334138 C1206.84375,170.722554 1440,366.366983 1440,421.483352 Z" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path></g></svg>';
				break;
			case 'wave-right-separator':
				$separator_svg = '<svg class="eut-separator eut-wave-right-separator" width="100%" height="100%" viewBox="0 0 1440 435" preserveAspectRatio="none"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><path d="M0,418.895124 C0,353.224824 233.15625,120.117519 521.46875,342.462329 C809.78125,564.807139 1025.92187,263.853008 1139.46094,97.8434653 C1253,-68.1660779 1440,17.1282856 1440,64.1991849 C1440,95.5797844 1440,219.180056 1440,435 L0,435 C0,424.263416 0,418.895124 0,418.895124 Z" fill="' . esc_attr( $color ) . '" fill-rule="nonzero" opacity="0.3"></path><path d="M0,421.483352 C0,366.366983 233.15625,170.722554 521.46875,357.334138 C809.78125,543.945722 1025.92187,291.358189 1139.46094,152.028182 C1253,12.6981757 1440,84.2848086 1440,123.790903 C1440,150.1283 1440,253.864665 1440,435 L0,435 C0,425.988902 0,421.483352 0,421.483352 Z" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path></g></svg>';
				break;
			case 'wave-2-right-separator':
				$separator_svg = '<svg class="eut-separator eut-wave-2-right-separator" width="100%" height="100%" viewBox="0 0 1440 420" preserveAspectRatio="none"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><path d="M0,420 C65.1666667,294.671661 152.195312,232.007492 261.085938,232.007492 C424.421875,232.007492 457.71875,292.511544 629.3125,292.511544 C800.90625,292.511544 947.695313,0 1141.60156,0 C1270.8724,0 1370.33854,57.4741761 1440,172.422528 L1440,420 L0,420 Z"  fill-opacity="0.6" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path><path d="M-9.09494702e-13,420 L-9.08870201e-13,174.156663 C81.640625,277.360175 195.044271,328.961931 340.210938,328.961931 C537.445312,328.961931 624.25,158.622328 753.804688,158.622328 C883.359375,158.622328 952.789062,352.008485 1146.69531,352.008485 C1275.96615,352.008485 1373.73437,303.774822 1440,207.307497 L1440,420 L-9.09494702e-13,420 Z"  fill-opacity="0.6" fill="' . esc_attr( $color ) . '" fill-rule="nonzero" transform="translate(720.000000, 289.311164) scale(-1, 1) translate(-720.000000, -289.311164) "></path><path d="M0,420 L0,329.553579 C65.3020833,237.547155 155.598958,191.543943 270.890625,191.543943 C443.828125,191.543943 805.984375,384.148487 1052.85938,384.148487 C1217.44271,384.148487 1346.48958,332.08177 1440,227.948335 L1440,420 L0,420 Z" fill-opacity="0.6" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path><path d="M0,420 L0,410.58481 C33.8854167,380.07824 129.744792,364.824955 287.578125,364.824955 C524.328125,364.824955 817.976563,420 1054.78125,420 C1212.65104,420 1341.05729,372.779097 1440,278.337292 L1440,420 L0,420 Z" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path></g></svg>';
				break;
			case 'wave-2-left-separator':
				$separator_svg = '<svg class="eut-separator eut-wave-2-left-separator" width="100%" height="100%" viewBox="0 0 1440 420" preserveAspectRatio="none"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><path d="M1440,420 L0,420 L0,172.422528 C69.6614583,57.4741761 169.127604,0 298.398438,0 C492.304688,0 639.09375,292.511544 810.6875,292.511544 C982.28125,292.511544 1015.57813,232.007492 1178.91406,232.007492 C1287.80469,232.007492 1374.83333,294.671661 1440,420 Z" fill-opacity="0.6" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path><path d="M1440,420 L0,420 L2.27373675e-13,207.307497 C66.265625,303.774822 164.033854,352.008485 293.304687,352.008485 C487.210937,352.008485 556.640625,158.622328 686.195312,158.622328 C815.75,158.622328 902.554687,328.961931 1099.78906,328.961931 C1244.95573,328.961931 1358.35937,277.360175 1440,174.156663 L1440,420 Z" fill-opacity="0.6" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path><path d="M1440,420 L0,420 L9.09494702e-13,227.948335 C93.5104167,332.08177 222.557292,384.148487 387.140625,384.148487 C634.015625,384.148487 996.171875,191.543943 1169.10937,191.543943 C1284.40104,191.543943 1374.69792,237.547155 1440,329.553579 L1440,420 Z" fill-opacity="0.6" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path><path d="M1440,420 L0,420 L0,278.337292 C98.9427083,372.779097 227.348958,420 385.21875,420 C622.023437,420 915.671875,364.824955 1152.42187,364.824955 C1310.25521,364.824955 1406.11458,380.07824 1440,410.58481 L1440,420 Z" fill="' . esc_attr( $color ) . '" fill-rule="nonzero"></path></g></svg>';
				break;
			case 'line-separator':
				$separator_svg = '<svg class="eut-separator eut-line-separator" width="100%" height="100%" viewBox="0 0 1440 100" preserveAspectRatio="none"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><rect fill="' . esc_attr( $color ) . '" fill-rule="nonzero" x="0" y="0" width="1440" height="100"></rect></g></svg>';
				break;
			case 'torn-paper-separator':
				$separator_svg = '<svg class="eut-separator eut-svg-torn" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="100%" height="100%" viewBox="0 0 1920 60" preserveAspectRatio="none"><path fill="' . esc_attr( $color ) . '" fill-rule="evenodd" clip-rule="evenodd" d="M42.728,16.599c9.228,14.816-39.39,9.974,36.298,6.492 c16.02-7.791,21.766-13.806,29.15-15.183c18.792,7.369,12.938,16.7,24.706,14.923c19.107,1.62,21.645,4.295,24.443,3.992 c19.532,0.602,23.42-2.739,27.408-2.238c15.269,8.654,29.658,7.357,39.264,6.713c8.322-3.869,4.44-10.481,4.44-10.481 c17.429,0.081,21.966,4.916,26.967,3.993c6.749-1.245,10.922-10.161,17.776-10.449c0.687,11.035,7.926,14.922,7.926,14.922 c16.338,7.064,27.334-2.205,40.743,0.748c20.006,0.072,36.746,9.646,46.255,1.268c64.623-56.952,28.432-5.807,39.489-16.938 c16.442,9.912,22.113,2.631,24.225,2.762c32.984,13.107,1.124,2.18,49.407,4.736c18.053,1.998,34.622-2.404,51.114-0.743 c16.608,1.674,2.018,14.925,18.518,9.698c6.111-1.936,10.884-7.164,17.038-8.955c21.589-2.432,24.99-8.342,30.373-9.697 c14.393,3.431,19.179,2.239,23.964,2.239c-7.127,7.735,34.558-0.999,42.263-7.463c16.464,3.134,17.354,5.277,18.775,6.979 c14.701,5.671,14.303,9.265,16.073,9.957c24.503,4.32,46.255,4.731,60.746-0.743c21.139-4.334,28.053-6.946,34.369-8.955 c12.832-4.081-1.319,7.396,15.558,8.207c17.235-6.42,20.293-9.697,23.963-9.697C912.494-8,844.468,8.95,866.353,8.95 c28.971,4.613,27.289-4.495,29.15-8.95c22.775,10.511,56.035,19.17,65.445,19.918c21.356-4.961,23.647-2.734,26.226-2.981 c22.418,2.435,29.441-2.548,37.035-2.986c30.947,12.058,3.238,1.833,40.264,5.225c26.562,5.928,31.99-0.134,47.406-2.986 c24.84-2.84,27.172-4.79,29.15-6.976c17.416,8.346,19.512-1.767,25.188,1.751c16.482,10.218,24.496,22.792,45.926,17.161 c10.627-5.809,28.699,1.072,31.373-0.744c15.418-5.719,14.408-10.484,16.334-9.96c15.781,4.358,18.074,6.828,21.039,7.722 c23.295,2.238,28.391-13.158,36.297-16.417c4.316-1.778,7.625,9.917,11.109,11.192c23.453-1.396,23.262,1.141,24.705,1.492 c92.949,22.566-17.523-4.687,26.447-2.235c13.688,7.079,22.062-1.5,27.408,1.491c25.576,7.956,37.385,2.982,45.186,2.982 c22.551-6.436,25.021-5.34,30.631-5.969c21.697,5.066,24.664,3.502,27.186,4.517c21.406,4.458,21.693,1.073,23.705,0 c49.031-15.261,116.562,3.021,116.562,3.021s30.617-2.253,37.814-11.94c23.543,4.434,28.74,7.078,34.334,7.723 c24.664,1.831,27.061-2.885,35.852-7.463c12.189,7.018,2.307,6.385,11.855,11.193c14.693-9.779,19.664-3.969,25.443-2.982 c23.627,4.029,6.672-0.377,20.004-5.972c10.193,8.832,19.617,2.306,27.408-0.744c25.084,0.585,39.549,2.333,47.395,4.143 c33.402-6.484,29.643-5.933,29.643-5.933V60H0V31.297C0,31.297,26.24,22.639,42.728,16.599L42.728,16.599z"/></svg>';
				break;
			default:
				$separator_svg = '';
				break;
		}

		$separator_svg = apply_filters( 'crocal_eutf_separator_svg', $separator_svg, $separator, $color );

		return $separator_svg;

	}
}

/**
 * Get CSS Color
 */
function crocal_eutf_get_css_color( $prefix, $color ) {
	$rgb_color = preg_match( '/rgba/', $color ) ? preg_replace( array( '/\s+/', '/^rgba\((\d+)\,(\d+)\,(\d+)\,([\d\.]+)\)$/' ), array( '', 'rgb($1,$2,$3)' ), $color ) : $color;
	$string = $prefix . ':' . $rgb_color . ';';
	if ( $rgb_color !== $color ) $string .= $prefix . ':' . $color . ';';
	return $string;
}

/**
 * Get hex2rgba Color
 */
function crocal_eutf_get_hex2rgba( $color = "#000000", $alpha = "1" ) {
	return "rgba(" . crocal_eutf_hex2rgb( $color ) . "," . $alpha . ")";
}

/**
 * Get Adaptive URL
 */
function crocal_eutf_get_adaptive_url( $media_id, $image_size = "responsive" ) {

	if ( 'full' == $image_size ) {
		$default_src = wp_get_attachment_image_src( $media_id, 'full'  );
		$img_url = $default_src[0];
	} elseif ( 'extra-extra-large' == $image_size ) {
		$default_src = wp_get_attachment_image_src( $media_id, 'crocal-eutf-fullscreen' );
		$img_url = $default_src[0];
	} else {
		$resolutions   = array( 2560, 1600, 768 );
		$hidpi         = TRUE;
		$resolution = FALSE;

		// Get resolution cookie
		if ( isset( $_GET['resolution'] ) ) {
			$cookie_resolution = $_GET['resolution'];
		} else if ( isset( $_COOKIE['resolution'] ) ) {
			$cookie_resolution = $_COOKIE['resolution'];
		} else {
			$cookie_resolution = null;
		}

		// Default values
		$client_width  = 1920;
		$pixel_density = 1;

		if ( isset( $cookie_resolution ) && preg_match( "/^[0-9]+[,]+[0-9.]+$/", $cookie_resolution ) ) {
			$cookie_array = explode( ',', $cookie_resolution );
			// Get screen width.
			if ( count( $cookie_array ) > 0 ) {
				$client_width  = intval( $cookie_array[0] );
			}
			// Get pixel density.
			if ( $hidpi ) {
				if ( count( $cookie_array ) > 1 ) {
					$pixel_density = $cookie_array[1];
				}
			}
		}

		// Scale client screen width according to its pixel density.
		$client_width_scaled = $client_width * $pixel_density;

		// Find the closest available resolution
		$closest = null;
		foreach ( $resolutions as $res ) {
			if ( $closest == null || abs( $client_width_scaled - $closest ) > abs( $res - $client_width_scaled ) ) {
				$closest = $res;
			}
		}
		$resolution = $closest;

		$default_src = wp_get_attachment_image_src( $media_id, 'crocal-eutf-fullscreen' );
		$skip_check = false;
		switch( $resolution ) {
			case '2560':
				$img_src = wp_get_attachment_image_src( $media_id, 'full' );
				$skip_check = true;
			break;
			case '768':
				$img_src = wp_get_attachment_image_src( $media_id, 'large' );
			break;
			case '1600':
			default:
				$img_src = $default_src;
			break;
		}

		if( $img_src[1] > $default_src[1]  && !$skip_check ) {
			$img_url = $default_src[0];
		} else {
			$img_url = $img_src[0];
		}
	}

	return $img_url;
}

/**
 * Get post width array
 */
if ( ! function_exists( 'crocal_eutf_get_post_width_array' ) ) {
	function crocal_eutf_get_post_width_array() {
		$crocal_eutf_width_array = array(
			'large' => 1170,
			'medium' => 970,
			'small' => 790,
		);
		return $crocal_eutf_width_array;
	}
}

/**
 * Extract video ID from youtube url
 */
if ( ! function_exists( 'crocal_eutf_extract_youtube_id' ) ) {
	function crocal_eutf_extract_youtube_id( $url ) {
		$youtube_id = "";
		parse_str( parse_url( $url, PHP_URL_QUERY ), $vars );
		if ( ! isset( $vars['v'] ) ) {
			$youtube_id = '';
		}
		$youtube_id = $vars['v'];

		return apply_filters( 'crocal_eutf_privacy_bg_youtube_id', $youtube_id );
	}
}

/**
 * Custom Content Filters
 */
add_filter( 'crocal_eutf_the_content', 'wptexturize'                       );
add_filter( 'crocal_eutf_the_content', 'convert_smilies',               20 );
add_filter( 'crocal_eutf_the_content', 'shortcode_unautop'                 );
add_filter( 'crocal_eutf_the_content', 'prepend_attachment'                );
add_filter( 'crocal_eutf_the_content', 'wp_make_content_images_responsive' );
add_filter( 'crocal_eutf_the_content', 'do_shortcode',                  11 );

//Omit closing PHP tag to avoid accidental whitespace output errors.
